/** 
* @file GT2004ContinuousBasicBehaviors.h
*
* Declaration of basic behaviors defined in continuous-basic-behaviors.xml.
*
* @author Martin Kallnik
* @author Max Risler
*/

#ifndef __GT2004ContinuousBasicBehaviors_h_
#define __GT2004ContinuousBasicBehaviors_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousBasicBehavior.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* @class ContinuousBasicBehaviors
*
* Creates and registers simple basic behaviors
*/
class GT2004ContinuousBasicBehaviors : public BehaviorControlInterfaces
{
public:
  /**
  * Constructor
  */
  GT2004ContinuousBasicBehaviors(
                       BehaviorControlInterfaces& interfaces,
                       Xabsl2ErrorHandler& errorHandler);

  /** Registers basic behaviors at the engine */
  void registerBasicBehaviors(Xabsl2Engine& engine);


  /** updates some variables */
  void update();

  //!@name Basic Behaviors parameters
  //!@{
  double turnRotationSpeed;

  double supporterPositionX;
  double supporterPositionY;
  double supporterPositionMaxSpeed;
  
  double offensiveSupporterPositionX;
  double offensiveSupporterPositionY;
  double offensiveSupporterPositionMaxSpeed;

  double goalieReturnX;
  double goalieReturnY;
  double goalieReturnMaxSpeed;
  
  //!@}

  /** known ball position used for some basic behaviors */
  Vector2<double> knownBallPos;

  /** known ball position in robot relative coordinates 
   * this is needed for basic behaviors that work with selflocator samples
   * as relative position has to be reconstructed first. */
  Vector2<double> knownBallPosRobotRelative;

  Vector2<double> knownPointBetweenBallandGoal;

private:
  /** Is invoked when errors occurs */
  Xabsl2ErrorHandler& errorHandler;

  //!@name Basic Behaviors
  //!@{
  ContinuousBasicBehavior turn;
  ContinuousBasicBehavior supporterPosition;
  ContinuousBasicBehavior offensiveSupporterPosition;
  ContinuousBasicBehavior goalieReturn;
  //!@}

};

#endif // __GT2004ContinuousBasicBehaviors_h_

/*
* Change Log
* 
* $Log: GT2004ContinuousBasicBehaviors.h,v $
* Revision 1.2  2004/07/01 14:19:07  altmeyer
* changed  transistions, replaced go-to-poin-behavouir through count-goalie-return
*
* Revision 1.1.1.1  2004/05/22 17:18:00  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2004/05/02 13:24:39  juengel
* Added GT2004BehaviorControl.
*
*/
