/** 
* @file ObstaclesSymbols.h
*
* Declaration of class ObstaclesSymbols.
*
* @author Max Risler
*/

#ifndef __ObstaclesSymbols_h_
#define __ObstaclesSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"


/**
* The Xabsl2 symbols that are defined in "obstacles-symbols.xml"
*
* @author Max Risler
*/ 
class ObstaclesSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  ObstaclesSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  bool getCollisionFrontLeft();  /*!< A function for the symbol "self.collision-front-left" */
  bool getCollisionFrontRight();  /*!< A function for the symbol "self.collision-front-right" */
  bool getCollisionHindLeft();  /*!< A function for the symbol "self.collision-hind-left" */
  bool getCollisionHindRight();  /*!< A function for the symbol "self.collision-hind-right" */
  bool getCollisionHead();  /*!< A function for the symbol "self.collision-head" */
  bool getCollisionAggregate();  /*!< A function for the symbol "self.collision-aggregate" */
  double getConsecutiveCollisionTimeFrontLeft();  /*!< A function for the symbol "self.consecutive-collision-time-front-left" */
  double getConsecutiveCollisionTimeFrontRight();  /*!< A function for the symbol "self.consecutive-collision-time-front-right" */
  double getConsecutiveCollisionTimeHindLeft();  /*!< A function for the symbol "self.consecutive-collision-time-hind-left" */
  double getConsecutiveCollisionTimeHindRight();  /*!< A function for the symbol "self.consecutive-collision-time-hind-right" */
  double getConsecutiveCollisionTimeHead();  /*!< A function for the symbol "self.consecutive-collision-time-head" */
  double getConsecutiveCollisionTimeAggregate();  /*!< A function for the symbol "self.consecutive-collision-time-aggregate" */
  int getCollisionSide();  /*!< A function for the symbol "self.collision-side" */
  //!@}

  /** Indicates if the robot is stuck (based on obstacles model)*/
  bool robotIsStuck;

  /** Indicates that there are close obstacles */
  bool obstaclesAreClose;

  /** Indicates that there are opponents in the direction of the ball */
  bool opponentsCloseToBall;
};


#endif // __ObstaclesSymbols_h_

/*
* Change Log
* 
* $Log: ObstaclesSymbols.h,v $
* Revision 1.3  2004/06/23 11:02:26  goehring
* Xabsl symbol collision-side added
*
* Revision 1.2  2004/06/16 15:24:11  risler
* no message
*
* Revision 1.1  2004/06/16 15:14:29  risler
* added obstacles symbols
* added symbol obstacles.opponent-close-to-ball
*
*
*/

