/** 
* @file MathFunctions.h
*
* Declaration of class MathFunctions.
*
* @author Matthias Jngel
*/

#ifndef __MathFunctions_h_
#define __MathFunctions_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "math-functions.xml"
*
* @author Matthias Jngel
*/ 
class MathFunctions : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  MathFunctions(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  /** calculates the decimal input function "distance-to" */
  double distanceTo();
  
  /** The parameter "distance-to.x" of the function "distance-to" */
  double distanceToX;
  
  /** The parameter "distance-to.y" of the function "distance-to" */
  double distanceToY;
    
  /** calculates the decimal input function "angle-to" */
  double angleTo();
  
  /** The parameter "angle-to.x" of the function "angle-to" */
  double angleToX;
  
  /** The parameter "angle-to.y" of the function "angle-to" */
  double angleToY;
    
  /** The parameter "normalize.angle" of the function "normalize" */
  double normalizeAngle;

  /** calculates the decimal input function "sgn" */
  double getSgn();

  /** calculates the decimal input function "min" */
  double getMin();

  /** calculates the decimal input function "max" */
  double getMax();

  /** calculates the decimal input function "abs" */
  double getAbs();

  /** calculates the decimal input function "random" */
  double getRandom();

  /** calculates the decimal input function "sin" */
  double getSin();

  /** calculates the decimal input function "cos" */
  double getCos();

  /** calculates the decimal input function "normalize" */
  double getNormalize();

  /** The parameter "sgn.value" of the function "sgn" */
  double sgnValue;

  /** The parameter "abs.value" of the function "abs" */
  double absValue;

  /** The parameter "min0.value" of the function "min" */
  double min0Value;

  /** The parameter "min1.value" of the function "min" */
  double min1Value;

  /** The parameter "max.value0" of the function "max" */
  double max0Value;

  /** The parameter "max.value1" of the function "max" */
  double max1Value;

  /** The parameter "*.alpha" of the function "sin" and "cos" */
  double alphaValue;

  /** calculates the value for the symbol "freeze.value" */
  double getFrozenValue(); 

  /** The parameter "freeze.value" of the function "freeze" */
  double valueToFreeze;

  /** The function returns 1 if the value is in the interval between a and b (order doesn't matter) */
  double isInInterval();

  double isInIntervalValue;
  double isInIntervalA;
  double isInIntervalB;

private:

  /* A flag to release frozenValue*/
  int unFreezeValue;

  /* The stored frozen value*/
  double frozenValue;

  //!@}
};


#endif // __MathFunctions_h_

/*
* Change Log
* 
* $Log: MathFunctions.h,v $
* Revision 1.1.1.1  2004/05/22 17:16:59  cvsadm
* created new repository GT2004_WM
*
* Revision 1.5  2004/04/08 15:33:01  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.4  2004/03/16 14:00:21  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.3  2004/03/08 00:58:56  roefer
* Interfaces should be const
*
* Revision 1.2  2004/03/11 17:32:20  loetzsch
* added input function "angle-to"
*
* Revision 1.2  2004/01/08 13:51:22  loetzsch
* added input function sin and cos
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/07/02 17:48:01  risler
* added math function abs
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/06/24 10:08:23  risler
* added function normalize
*
* Revision 1.2  2003/06/19 14:48:24  risler
* symbol random added
*
* Revision 1.1  2003/05/07 17:54:39  juengel
* Added missing symbols to GT2003BehaviorControl.
*
*/

