/** 
* @file KickSelectionSymbols.cpp
*
* Implementation of class KickSelectionSymbols.
*
* @author Martin Ltzsch
*/

#include "KickSelectionSymbols.h"


KickSelectionSymbols::KickSelectionSymbols(BehaviorControlInterfaces& interfaces, 
                                           const char* fileName)
: BehaviorControlInterfaces(interfaces)
{
  kickSelectionTable.load(fileName);
}


void KickSelectionSymbols::registerSymbols(Xabsl2Engine& engine)
{
  engine.registerDecimalInputFunction("retrieve-kick",this,
    (double (Xabsl2FunctionProvider::*)())&KickSelectionSymbols::retrieveKick);
  engine.registerDecimalInputFunctionParameter("retrieve-kick","retrieve-kick.angle",angle);
  engine.registerDecimalInputFunctionParameter("retrieve-kick","retrieve-kick.table-id",tableID);
}

double KickSelectionSymbols::retrieveKick()
{
  if (SystemCall::getTimeSince(ballModel.seen.timeUntilSeenConsecutively) < 200
    && ballModel.seen.timeUntilSeenConsecutively - ballModel.seen.timeWhenFirstSeenConsecutively > 150)
  {
    return kickSelectionTable.retrieveKick(Geometry::distanceTo(robotPose.getPose(),ballModel.seen)
      * cos(Geometry::angleTo(robotPose.getPose(),ballModel.seen)),
      Geometry::distanceTo(robotPose.getPose(),ballModel.seen)
      * sin(Geometry::angleTo(robotPose.getPose(),ballModel.seen)),
      angle, (KickSelectionTable::KickSelectionTableID)(int)tableID);
  }
  else
  {
    return KickSelectionTable::nothing;
  }
}

bool KickSelectionSymbols::handleMessage(InMessage& message)
{
  if(message.getMessageID() == idKickSelectionTable)
  {
    message.text >> kickSelectionTable;
    return true;
  }
  else return false;
}

/*
* Change Log
* 
* $Log: KickSelectionSymbols.cpp,v $
* Revision 1.1  2004/05/22 21:31:04  loetzsch
* adopted kick selection table to GT2004
*
* Revision 1.6  2004/05/04 16:25:08  loetzsch
* bug fixes
*
* Revision 1.5  2004/04/14 10:44:44  loetzsch
* started redesing of ball handling options
*
* Revision 1.4  2004/03/27 15:47:45  loetzsch
* ::retrieveKick does not check anymore whether the ball was seen before
*
* Revision 1.3  2004/03/19 21:19:28  altmeyer
* SideHeadKick and SideHeadKick2 changed and renamed to SideHeadKick L and SideHeadKickR
* a few ATH ERS7-kicks removed
*
* Revision 1.2  2004/03/17 19:57:48  juengel
* handleMessage() for kickSelectionSymbols added.
*
* Revision 1.1  2004/03/16 14:00:18  juengel
* Integrated Improvments from "Gnne"
* -ATH2004ERS7Behavior
* -ATHHeadControl
* -KickSelectionTable
* -KickEditor
*
* Revision 1.4  2004/03/10 18:40:59  loetzsch
* first functioning version
*
* Revision 1.3  2004/03/10 13:32:18  loetzsch
* continued option "approach-and-kick"
*
* Revision 1.2  2004/03/09 18:48:47  loetzsch
* kick selection table changes
*
* Revision 1.1  2004/03/09 13:44:49  loetzsch
* added class ATH2004ERS7KickSelectionSymbols
*
*/

