/** 
* @file JoystickSymbols.h
*
* Declaration of class JoystickSymbols.
*
* @author Matthias Jngel
*/

#ifndef __JoystickSymbols_h_
#define __JoystickSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "joystick-symbols.xml"
*
* @author Matthias Jngel
*/ 
class JoystickSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  JoystickSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  int getJoystickButton(); /*!< A function for the symbol "joystick-data.button" */
  double getJoystickTimeSinceLastMessage(); /*!< A function for the symbol "joystick-data.time-since-last-message" */
  double getSpecialActionId(); /*!< A function for the symbol "joystick-data.special-action-id" */
  //!@}
};


#endif // __JoystickSymbols_h_

/*
* Change Log
* 
* $Log: JoystickSymbols.h,v $
* Revision 1.1.1.1  2004/05/22 17:16:58  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/04/26 15:58:59  thomas
* added new project RobotRemote based on ATHAiboControl
*
* Revision 1.2  2004/03/08 00:58:56  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/07 17:54:39  juengel
* Added missing symbols to GT2003BehaviorControl.
*
*/

