/** 
* @file ChallengeSymbols.h
*
* Declaration of class ChallengeSymbols.
*
* @author Thomas Rfer
*/

#ifndef __ChallengeSymbols_h_
#define __ChallengeSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "challenge-symbols.xml"
*
* @author Thomas Rfer
*/ 
class ChallengeSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The parameters of the BehaviorControl module.
  */
  ChallengeSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

  /** updates the symbols */
  void update();
  void challenge2Swap(Pose2D* p, int i, int j);
  void challenge2ShortestPermutation(Pose2D* p, int n, double& minLength);
  void challenge2ShortestPath();
  void challenge2OptimalRotation(Pose2D& pose);
  double challenge2TargetPositionX(); /**< Returns x coordinate of target position with current index. */
  double challenge2TargetPositionY(); /**< Returns y coordinate of target position with current index. */
  double challenge2TargetPositionRotation(); /**< Returns rotation of target position with current index. */
private:
  Pose2D targetPositions[5]; /**< The 5 target positions for the localization challenge */
  double index, /**< the index for targetPosition? functions */
         lastIndex; /**< The index of the previous call */

};


#endif // __ChallengeSymbols_h_

/*
* Change Log
* 
* $Log: ChallengeSymbols.h,v $
* Revision 1.2  2004/06/28 12:27:59  schumann
* part 1 of the almost slam challenge behavior
*
* Revision 1.1.1.1  2004/05/22 17:16:57  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/03/08 00:58:55  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
*/

