/** 
* @file BallSymbols.h
*
* Declaration of class BallSymbols.
*
* @author Martin Ltzsch
*/

#ifndef __BallSymbols_h_
#define __BallSymbols_h_

#include "../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

#include "Tools/RingBufferWithSum.h"

/**
* The Xabsl2 symbols that are defined in "ball-symbols.xml"
*
* @author Martin Ltzsch
*/ 
class BallSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the BehaviorControl module.
  */
  BallSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  double getNumberOfImagesWithBallPercept(); /*!< A function for the symbol "ball.number-of-images-with-ball-percept" */
  double getNumberOfImagesWithoutBallPercept(); /*!< A function for the symbol "ball.number-of-images-without-ball-percept" */
  double getSeenDistance(); /*!< A function for the symbol "ball.seen.distance" */
  double getSeenAngle(); /*!< A function for the symbol "ball.seen.angle" */
  double getSeenSpeed(); /*!< A function for the symbol "ball.seen.speed" */
  double getSeenRelativeSpeedX(); /*!< A function for the symbol "ball.seen.relative-speed.x" */
  double getSeenRelativeSpeedY(); /*!< A function for the symbol "ball.seen.relative-speed.y" */
  double getSeenDistanceX(); /*!< A function for the symbol "ball.seen.distance-x" */
  double getSeenDistanceY(); /*!< A function for the symbol "ball.seen.distance-y" */
  double getProjectedDistanceOnYAxis(); /*!< A function for the symbol "ball.projectedDistanceOnYAxis" */
  double getTimeUntilBallCrossesYAxis(); /*!< A function for the symbol "ball.timeBallCrossesYAxis" */
  double getDistanceSeenBallToOwnPenaltyArea(); /*!< A function for the symbol "ball.seen.distance-to-own-penalty-area" */
  double getTimeSinceLastSeen(); /*!< A function for the symbol "ball.time-since-last-seen" */
  double getConsecutivelySeenTime(); /*!< A function for the symbol "ball.consecutively-seen-time" */
  double getTimeSinceLastSeenConsecutively(); /*!< A function for the symbol "ball.time-since-last-seen-consecutively" */
  bool getBallSeenInFrontOfOpponentGoal(); /*!< A function for the symbol "ball.seen.ball-in-front-of-opponent-goal */
  bool getJustSeen(); /*!< A function for the symbol "ball.just-seen" */
  double getKnownDistance(); /*!< A function for the symbol "ball.known.distance" */
  double getKnownAngle(); /*!< A function for the symbol "ball.known.angle" */
  double getKnownX(); /*!< A function for the symbol "ball.known.x" */
  double getKnownY(); /*!< A function for the symbol "ball.known.y" */
  double getTimeSinceLastKnown(); /*!< A function for the symbol "ball.time-since-last-known" */
  double getTimeAfterWhichCommunicatedBallAreAccepted(); /*!< A function for the symbol "ball.time-after-which-communicated-balls-are-accepted" */
  double getMotionValidity(); /*!< A function for the symbol "ball.seen.movementValidity" */
  double getAngleToOpponentGoal(); /*!< calculates the value for the symbol "ball.angle-to-opponent-goal" */
  //!@}


private:
  /** A ring buffer needed to calculate the average ball distance */
  RingBufferWithSum<60> ballDistanceRingBuffer;

  /** The average distane to the ball */
  double averageDistance;

  /** Whether the ball is handled at the moment */
  bool ballIsHandledAtTheMoment;

  /** Whether the ball was handled in the last frame */
  int ballWasHandledInLastFrame;


  bool playBallPrecisely;

  int ballPrecision;


};


#endif // __BallSymbols_h_

/*
* Change Log
* 
* $Log: BallSymbols.h,v $
* Revision 1.5  2004/06/27 17:41:02  goetzke
* Added penalty-shooter.
*
* Revision 1.4  2004/06/23 11:37:43  dassler
* New Ballsymbols introduced
* ball.projected-distance-on-y-axis" description="Projected Distance of the ball to the y axis of the robot
* ball.time-until-ball-crosses-y-axis" description="Time until the ball crosses the y axis of the robot
*
* Revision 1.3  2004/06/15 17:50:24  juengel
* Added symbols:
* numberOfImagesWithBallPercept,
* numberOfImagesWithoutBallPercept
*
* Revision 1.2  2004/05/27 18:49:17  kerdels
* added a small 5 frames sliding average for the relative ballspeed,
* added new ballState Representation and adjusted the apropriate files
*
* Revision 1.1.1.1  2004/05/22 17:16:57  cvsadm
* created new repository GT2004_WM
*
* Revision 1.10  2004/04/15 13:12:27  loetzsch
* added setting of the symbol "ball.handling"
*
* Revision 1.9  2004/04/14 20:35:28  loetzsch
* i.m.p.r.o.v.e.d.
*
* Revision 1.8  2004/04/08 15:33:01  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.7  2004/04/05 17:56:47  loetzsch
* merged the local German Open CVS of the aibo team humboldt with the tamara CVS
*
* Revision 1.3  2004/04/02 11:44:30  jumped
* addded ball.seen.in.front-of-opponent-goal (and supporting functions)
*
* Revision 1.2  2004/04/01 22:08:37  juengel
* Added ball.average-distance.
*
* Revision 1.1.1.1  2004/03/31 11:16:41  loetzsch
* created ATH repository for german open 2004
*
* Revision 1.6  2004/03/28 16:33:58  loetzsch
* added input symbol ball.consecutively-seen-time and ball.time-since-last-consecutively-seen
*
* Revision 1.5  2004/03/27 14:45:41  loetzsch
* added boolean input symbol "ball.seen-consecutively"
*
* Revision 1.4  2004/03/08 00:58:54  roefer
* Interfaces should be const
*
* Revision 1.3  2004/02/05 14:21:03  spranger
* added ballState enum
*
* Revision 1.2  2004/01/29 09:52:43  schumann
* added motion validity symbol to xabsl
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
* Revision 1.1  2003/10/06 13:39:28  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.8  2003/06/22 14:54:12  risler
* ball.seen.relative-speed.x/y added
*
* Revision 1.7  2003/06/19 14:49:04  risler
* symbol ball.getting-closer added
*
* Revision 1.6  2003/06/18 18:31:29  risler
* added relative ball position
*
* Revision 1.5  2003/06/17 19:54:59  risler
* ball caught symbols moved to strategy
*
* Revision 1.4  2003/06/04 11:17:14  risler
* added symbol ball.seen.distance-to-own-penalty-area
*
* Revision 1.3  2003/06/02 03:57:52  loetzsch
* copied a simple goalie behavior from humboldt2003
*
* Revision 1.2  2003/05/09 15:29:06  loetzsch
* added time-after-which-communicated-ball-are-accepted
*
* Revision 1.1  2003/05/04 11:41:40  loetzsch
* added class BallSymbols
*
*/

