/** 
* @file CommonBasicBehaviors.cpp
*
* Implementation of basic behaviors defined in simple-basic-behaviors.xml.
*
* @author Uwe Dffert
* @author Matthias Jngel
* @author Martin Ltzsch
* @author Max Risler
*/

#include "CommonBasicBehaviors.h"

void CommonBasicBehaviors::registerBasicBehaviors(Xabsl2Engine& engine)
{
  engine.registerBasicBehavior(basicBehaviorDoNothing);
  engine.registerBasicBehavior(basicBehaviorShutdown);
  engine.registerBasicBehavior(basicBehaviorSpecialAction);
  engine.registerBasicBehavior(basicBehaviorStand);
  engine.registerBasicBehavior(basicBehaviorPlayDead);
  engine.registerBasicBehavior(basicBehaviorWalk);
}

void BasicBehaviorShutdown::execute()
{
  SystemCall::shutdown();
}

void BasicBehaviorDoNothing::execute()
{
  // do nothing;
}

void BasicBehaviorWalk::execute()
{
  motionRequest.motionType = MotionRequest::walk;
  motionRequest.walkRequest.walkType   = static_cast<WalkRequest::WalkType>(static_cast<int>(type));
  if(motionRequest.walkRequest.walkType >= WalkRequest::numOfWalkType || motionRequest.walkRequest.walkType < 0)
    motionRequest.walkRequest.walkType = WalkRequest::normal;
  motionRequest.walkRequest.walkParams.translation.x = speedX;
  motionRequest.walkRequest.walkParams.translation.y = speedY;
  motionRequest.walkRequest.walkParams.rotation = fromDegrees(rotationSpeed);
}

void BasicBehaviorSpecialAction::execute()
{
  motionRequest.motionType = MotionRequest::specialAction;
  motionRequest.specialActionRequest.specialActionType = static_cast<SpecialActionRequest::SpecialActionID>(static_cast<int>(specialActionID));
}

void BasicBehaviorStand::execute()
{
  accelerationRestrictor.saveLastWalkParameters();

  motionRequest.walkRequest.walkParams.translation.x = 0;
  motionRequest.walkRequest.walkParams.translation.y = 0;
  motionRequest.walkRequest.walkParams.rotation = 0;

  accelerationRestrictor.restrictAccelerations(250,250,150);

  if (fabs(motionRequest.walkRequest.walkParams.translation.x) < 30
    && fabs(motionRequest.walkRequest.walkParams.translation.y) < 30
    && fabs(motionRequest.walkRequest.walkParams.rotation) < fromDegrees(30))
  {
    motionRequest.motionType = MotionRequest::stand;
  }
}
void BasicBehaviorPlayDead::execute()
{
  motionRequest.motionType = MotionRequest::playDead;
}


/*
* Change Log
* 
* $Log: CommonBasicBehaviors.cpp,v $
* Revision 1.4  2004/06/17 14:14:28  spranger
* if walk is selected in the xabsl-dialog, stupid things can happen with walk-type
* fixed
*
* Revision 1.3  2004/06/14 15:06:13  spranger
* added playDead-basic behavior
*
* Revision 1.2  2004/06/02 17:18:23  spranger
* MotionRequest cleanup
*
* Revision 1.1.1.1  2004/05/22 17:16:56  cvsadm
* created new repository GT2004_WM
*
* Revision 1.8  2004/05/04 20:24:54  loetzsch
* minor improvments
*
* Revision 1.7  2004/05/04 10:48:58  loetzsch
* replaced all enums
* xxxBehaviorControlTimeAfterWhichCommunicatedBallsAreAccepted
* by
* behaviorControlTimeAfterWhichCommunicatedBallsAreAccepted
* (this mechanism was neither fully implemented nor used)
*
* Revision 1.6  2004/04/08 15:33:01  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.5  2004/04/07 13:44:33  risler
* ddd checkin after go04 - second part fixed walktype
*
* Revision 1.4  2004/04/07 12:28:56  risler
* ddd checkin after go04 - first part
*
* Revision 1.3  2004/03/29 17:49:27  loetzsch
* added walk type turnWithBall4
*
* Revision 1.2  2004/03/17 21:08:38  cesarz
* Added turnWithBall3, which points to MSH2004TurnWithBallWalkingParameters.
*
* Revision 1.1  2003/10/22 22:18:44  loetzsch
* prepared the cloning of the GT2003BehaviorControl
*
*/

