/**
* @file ValidityBasedBallLocator.cpp
* 
* This file contains the default class for ball-localization.
*
* @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
*/



//Freiheitsgrade: Anzahl Frames: maxRegressionFrame; Step: validityStep;
//Cameramatrix valid?
//Propagate when not seen
//Odometry!!!
//Wenn Roboter laeuft, dann nicht so schnell neuer Geschwindigkeit glauben!! PID
//Konfigurationen fuer Reaktiv oder Sicher
//Clipping bei kleinen Geschwindigkeiten

//done: Ballentfernung > 1500 mm, dann keine Geschwindigkeit berechnen
//done: Bei geringer Validitaet wird ueber mehr Werte gemittelt bzw. deren Minimum berechnet
//done: Ringpuffer aus letzten Validitaeten, ballModelen, Perzepten, Geschwindigkeiten, Framenummern
//done: mittle Geschwindigkeit abh. von Framezahlen
//done: NORMALIZE CHANGES BY Frame!!!


#include "ValidityBasedBallLocator.h"
#include "Tools/Debugging/Debugging.h"

#include "Tools/FieldDimensions.h"
#include "Platform/SystemCall.h"
#include "Tools/Debugging/DebugDrawings.h"
#include <math.h>
#include "Tools/Math/Matrix2x2.h"
#include "Platform/GTAssert.h"


ValidityBasedBallLocator::ValidityBasedBallLocator(const BallLocatorInterfaces& interfaces)
: BallLocator(interfaces)
{
  for (int i = 0; i < historySize; i++)
  {
    for (int j = 0; j < numOfBallStateProperties; j++)
    {
      offset[j][i].x = 0;
      offset[j][i].y = 0;
    }
    
    
    for (int k = 0; k < numOfBallStateProperties; k++)
    {
      ballPose[k][i].x = 0;
      ballPose[k][i].y = 0;
    }
    
    //robot Odometry
    

    validity[historySize] = 0.0;
    frameNumber[historySize] = 0;
    step = 0;
  }
  
  ballOffset.x = 0;
  ballOffset.y = 0;
  ballOffsetByBearing.x = 0;
  ballOffsetByBearing.y = 0;
  ballOffsetBySize.x = 0;
  ballOffsetBySize.y = 0;
  dFrameNumber = 0;
  set = false;
  validityStep = 0.08;  
  maxDist = 1500;
  minSpeedAbs = 50;
  consecutiveFramesBallSeen = 0;
  consecutiveFramesBallNotSeen = 0;
  distance = 0;
  angle = 0;

}


unsigned long ValidityBasedBallLocator::frameToImageNumber(unsigned long imageDiff)
{
  unsigned long g = (unsigned long)((imageDiff - (imageDiff%25)) / 25) * 6;
  unsigned long k;
  
  if ((imageDiff%25) < 4) {k = 0;}
  else if ((imageDiff%25) < 8) {k = 1;}
  else if ((imageDiff%25) < 12) {k = 2;}
  else if ((imageDiff%25) < 16) {k = 3;}
  else if ((imageDiff%25) < 20) {k = 4;}
  else {k = 5;}
  
  return (g + k);
}



void ValidityBasedBallLocator::execute()
{  
  if(step == 0) 
  {
     lastRobotOdometry = odometryData;
  }
  distOdometry = odometryData - lastRobotOdometry;


  if(!ballPercept.ballWasSeen)
  {
    consecutiveFramesBallSeen = 0;
    consecutiveFramesBallNotSeen++;
    
    ballPose[speed][step%historySize].x = 0;
    ballPose[speed][step%historySize].y = 0;
    
    /*
    double x = ballModel.propagated.x * cos(distOdometry.rotation) - 
              ballModel.propagated.y * sin(distOdometry.rotation);
    double y = ballModel.propagated.x * sin(distOdometry.rotation) + 
              ballModel.propagated.y * cos(distOdometry.rotation);
    */

    lastPropagated.x = ballModel.propagated.x;
    lastPropagated.y = ballModel.propagated.y;
 
    validity[step%historySize] = validity[(step + historySize - 1)%historySize] * 0.9;
    
    
  }
  else // ball was seen
  {
    
    // if there is a gap of n frames during which the ball was not seen
    // reset the "timeWhenLastSeenConsecutively"
    if (consecutiveFramesBallNotSeen > 5)
    {
      ballModel.seen.timeWhenFirstSeenConsecutively = SystemCall::getCurrentSystemTime();
    }
    
    // if ball has not been seen for a while but 
    // is seen now, directly (re-)set to percept...
    if (consecutiveFramesBallNotSeen > 10) 
    {
      //reset
    }
    // ball was seen recently
    else  
    {
      // calc ball speed:
    }
    
    
    frameNumber[step%historySize] = ballPercept.frameNumber;
    
    ballPercept.getOffset(offset[original][step%historySize]);
    ballPercept.getOffsetBearingBased(offset[bearing][step%historySize]);
    ballPercept.getOffsetSizeBased(offset[size][step%historySize]);    
    
    //double distanceBearingBased = ballPercept.getDistanceBearingBased();
    //double distanceSizeBased = ballPercept.getDistanceSizeBased();
    
    if ((offset[bearing][step%historySize].abs() <= 1) || 
      (offset[size][step%historySize].abs() <= 1))
    {
      validity[step%historySize] = 0.0;
    }
    else
    {
      validity[step%historySize] = offset[bearing][step%historySize].abs()/offset[size][step%historySize].abs();
      if (validity[step%historySize] > 1)
      {
        validity[step%historySize] = offset[size][step%historySize].abs()/offset[bearing][step%historySize].abs();
      }
    }
    
    /*    OUTPUT(idText, text, "Validitaet: " << perceptValidity);
    
      if (perceptValidity > 0.95)
      {
      OUTPUT(idText, text, "Distanz " << distanceSizeBased);
      }
    */
    consecutiveFramesBallSeen++;
    consecutiveFramesBallNotSeen = 0;
    
    ballModel.seen.timeWhenLastSeen = SystemCall::getCurrentSystemTime();
    
    offset[combined][step%historySize].x  = 0.5*(offset[size][step%historySize].x + offset[bearing][step%historySize].x) * validity[step%historySize] + (offset[combined][(step+historySize-1)%historySize].x) * (1 - validity[step%historySize]);
    offset[combined][step%historySize].y  = 0.5*(offset[size][step%historySize].y + offset[bearing][step%historySize].y) * validity[step%historySize] + (offset[combined][(step+historySize-1)%historySize].y) * (1 - validity[step%historySize]);
    
    ballModel.seen = 
      Geometry::relative2FieldCoord(robotPose, offset[combined][step%historySize].x, offset[combined][step%historySize].y); 
    
    
    lastPropagated.x = ballModel.propagated.x;
    lastPropagated.y = ballModel.propagated.y;
    
    
    ballPose[seen][step%historySize] = ballModel.seen;
    
    avgValidity[0] = validity[step%historySize];
    
    for (int i = 1; i < maxRegressionFrames; i++)
    {
      avgValidity[i] = 1.0 / ((double)i) * (avgValidity[i-1]*(i-1) + validity[(step+historySize-(i-1))%historySize]);
      //      OUTPUT(idText, text, "Validitaet " << i << ": "<< avgValidity[i]);       
    }

 
  }   
  
  step++;
  lastRobotOdometry = odometryData;
}



bool ValidityBasedBallLocator::handleMessage(InMessage& message)
{
  return false;
}




/*
* Change log :
* 
* $Log: ValidityBasedBallLocator.cpp,v $
* Revision 1.5  2004/07/01 12:38:28  dassler
* introduced new Balllocator KalmanComboBallLocator
* ball.seen is set by the Validity and the rest by the Kalman Filter
*
* Revision 1.4  2004/05/27 09:53:33  loetzsch
* removed "timeOfImageProcessing"
*
* Revision 1.3  2004/05/26 00:09:31  goehring
* ValidityBasedBallLocator added
*
* Revision 1.11  2004/05/24 19:40:06  goehring
* ballModel to ballModel renamed
*
* Revision 1.10  2004/05/18 20:34:02  goehring
* Look at ball improved
*
* Revision 1.9  2004/05/17 14:11:44  goehring
* ballModel.propagated.speed implemented
*
* Revision 1.8  2004/05/05 21:19:53  goehring
* no message
*
* Revision 1.7  2004/05/03 15:29:48  roefer
* Warnings removed
*
* Revision 1.6  2004/04/27 18:22:06  goehring
* Speed clipping for small speeds implemented
*
* Revision 1.5  2004/04/27 15:51:30  goehring
* Speed model improved
*
* Revision 1.4  2004/04/27 13:04:44  goehring
* Speed calculation improved
*
* Revision 1.3  2004/04/27 11:04:50  goehring
* Speed calculation improved
*
* Revision 1.2  2004/04/26 15:37:57  goehring
* SpeedCalculation optimized
*
* Revision 1.1  2004/04/21 20:11:40  goehring
* BallLocators added
*
* Revision 1.1.1.1  2004/03/31 11:16:37  loetzsch
* created ATH repository for german open 2004
*
* Revision 1.34  2004/03/08 00:58:33  roefer
* Interfaces should be const
*
* Revision 1.33  2004/02/21 18:36:52  roefer
* Warnings removed
*
* Revision 1.32  2004/02/11 12:03:36  kerdels
* added comment at compiler warnings
*
* Revision 1.31  2004/02/08 22:05:28  goehring
* Design change to ringbuffers
*
* Revision 1.30  2004/02/06 18:45:39  goehring
* Concept Change
*
* Revision 1.7  2004/02/05 21:40:28  goehring
* Review
*
* Revision 1.6  2004/02/05 21:36:50  goehring
* Validity tested
*
* Revision 1.5  2004/01/25 20:54:46  goehring
* no message
*
* Revision 1.4  2004/01/20 16:45:52  loetzsch
* The BallLocator has access to the complete ballModel again
*
* Revision 1.3  2003/12/31 23:50:35  roefer
* Removed inclusion of RobotDimensions.h because it is not used
*
* Revision 1.2  2003/12/02 15:12:16  goehring
* ballModel algorithm added
*
* Revision 1.1  2003/12/02 13:51:01  goehring
* no message
*
*
*/
