/**
 * @file PerceptBallLocator.h
 * 
 * This file contains a default class for ball-localization.
 *
 * @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
 */

#ifndef __PerceptBallLocator_h_
#define __PerceptBallLocator_h_

#include "BallLocator.h"
#include "Tools/Debugging/GenericDebugData.h"

/**
* @class PerceptBallLocator
*
* A solution of the BallLocator module.
*
*
 * @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
*/
class PerceptBallLocator : public BallLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BallLocator module.
  */
  PerceptBallLocator(const BallLocatorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

private:
	
    Vector2<double> lastBallSeen;

    Pose2D lastRobotOdometry; 

    Vector2<double> relative2FieldCoord(RobotPose rp, double x, double y);
    void compensateOdometry();

    bool handleMessage(InMessage& message);
};

#endif// __PerceptBallLocator_h_

/*
 * Change log :
 * $Log: PerceptBallLocator.h,v $
 * Revision 1.3  2004/07/02 09:31:27  jhoffman
 * Kalman-Combo now uses the "PerceptBallLocator" for the position; odometry is used for propagation of position when ball is not seen
 *
 * Revision 1.7  2004/05/22 16:28:45  goehring
 * no message
 *
 * Revision 1.6  2004/04/21 20:11:40  goehring
 * BallLocators added
 *
 * Revision 1.5  2004/03/08 00:58:37  roefer
 * Interfaces should be const
 *
 * Revision 1.4  2004/02/06 18:45:39  goehring
 * Concept Change
 *
 * Revision 1.2  2003/12/09 16:33:10  jhoffman
 * - some cleaning up
 *
 * Revision 1.1  2003/12/02 13:51:01  goehring
 * no message
 *
 * 
 *
 */
