/**
* @file PerceptBallLocator.cpp
* 
* This file contains the default class for ball-localization.
*
* @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
*/


//NORMALIZE CHANGES BY Frame!!!

#include "PerceptBallLocator.h"
#include "Tools/Debugging/Debugging.h"

#include "Tools/FieldDimensions.h"
#include "Platform/SystemCall.h"
#include "Tools/Debugging/DebugDrawings.h"
#include <math.h>
#include "Tools/Math/Matrix2x2.h"
#include "Platform/GTAssert.h"



PerceptBallLocator::PerceptBallLocator(const BallLocatorInterfaces& interfaces)
: BallLocator(interfaces), lastRobotOdometry()
{}

void PerceptBallLocator::execute()
{
  if(ballPercept.ballWasSeen) // ball was seen
  {
    Vector2<double> ballOffset;
    ballPercept.getOffset(ballOffset);

    lastBallSeen = ballOffset;
  }
  else // ball was not seen
  {
    compensateOdometry();
  }
  
  ballModel.seen = 
    Geometry::relative2FieldCoord(robotPose, lastBallSeen.x, lastBallSeen.y); 

  lastRobotOdometry = odometryData;
}

bool PerceptBallLocator::handleMessage(InMessage& message)
{
  return false;
}


void PerceptBallLocator::compensateOdometry()
{
  lastBallSeen = (lastRobotOdometry + Pose2D(lastBallSeen) - odometryData).translation;
}        





	

/*
* Change log :
* 
* $Log: PerceptBallLocator.cpp,v $
* Revision 1.4  2004/07/02 18:27:44  jhoffman
* bug fix
*
* Revision 1.3  2004/07/02 09:31:27  jhoffman
* Kalman-Combo now uses the "PerceptBallLocator" for the position; odometry is used for propagation of position when ball is not seen
*
* Revision 1.10  2004/05/22 16:28:45  goehring
* no message
*
* Revision 1.9  2004/03/08 00:58:37  roefer
* Interfaces should be const
*
* Revision 1.8  2004/02/06 18:45:39  goehring
* Concept Change
*
* Revision 1.4  2004/01/20 16:45:52  loetzsch
* The BallLocator has access to the complete ballModel again
*
* Revision 1.3  2003/12/31 23:50:35  roefer
* Removed inclusion of RobotDimensions.h because it is not used
*
* Revision 1.2  2003/12/02 15:12:16  goehring
* ballModel algorithm added
*
* Revision 1.1  2003/12/02 13:51:01  goehring
* no message
*
*
*/
