/**
 * @file
 * 
 * This file contains a default class for ball-localization.
 *
 * @author <a href="mailto:marc.dassler@web.de">Marc Dassler</a>
 */

#ifndef __KalmanComboBallLocator_h_
#define __KalmanComboBallLocator_h_

#include "BallLocator.h"
#include "Tools/Debugging/GenericDebugData.h"
#include "KalmanBallLocator.h"
#include "PerceptBallLocator.h"


/**
* @class KalmanComboBallLocator
*/
class KalmanComboBallLocator : public BallLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BallLocator module.
  */
  KalmanComboBallLocator(const BallLocatorInterfaces& interfaces,
    BallLocator *kalman,
    BallLocator *percept);


  ~KalmanComboBallLocator();
  /** Executes the module */
  virtual void execute();


private:
	
  BallLocator *kalmanBallLocator;
  BallLocator *perceptBallLocator;
};

#endif
/*
 * Change log :
 * $Log: KalmanComboBallLocator.h,v $
 * Revision 1.2  2004/07/02 09:31:27  jhoffman
 * Kalman-Combo now uses the "PerceptBallLocator" for the position; odometry is used for propagation of position when ball is not seen
 *
 * Revision 1.1  2004/07/01 12:54:05  dassler
 * introduced new Balllocator KalmanComboBallLocator
 * ball.seen is set by the Validity and the rest by the Kalman Filter
 *
 */
