/**
* @file KalmanComboBallLocator.cpp
* 
* This file contains the default class for ball-localization.
*
* @author <a href="mailto:goehring@informatik.hu-berlin.de">Daniel Goehring</a>
*/



#include "KalmanComboBallLocator.h"
#include "Tools/Debugging/Debugging.h"
#include "KalmanBallLocator.h"
#include "PerceptBallLocator.h"


KalmanComboBallLocator::KalmanComboBallLocator(const BallLocatorInterfaces& interfaces,
    BallLocator *kalman,
    BallLocator *percept)
: BallLocator(interfaces)
{
  kalmanBallLocator = kalman;
  perceptBallLocator = percept;
}


KalmanComboBallLocator::~KalmanComboBallLocator()
{
  delete kalmanBallLocator;
  delete perceptBallLocator;
};

void KalmanComboBallLocator::execute()
{
  kalmanBallLocator->execute();
  perceptBallLocator->execute();  
};

/*
* Change log :
* 
* $Log: KalmanComboBallLocator.cpp,v $
* Revision 1.2  2004/07/02 09:31:27  jhoffman
* Kalman-Combo now uses the "PerceptBallLocator" for the position; odometry is used for propagation of position when ball is not seen
*
* Revision 1.1  2004/07/01 12:54:05  dassler
* introduced new Balllocator KalmanComboBallLocator
* ball.seen is set by the Validity and the rest by the Kalman Filter
*
*
*/
