/**
* @file MakeStick.cpp
* The main class of the MakeStick tool.
*
* @author Tim Riemenschneider
* @author Thomas Roefer
* @author Tim Laue
*/

#include "stdafx.h"
#include "MakeStick.h"
#include "MakeStickDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



BEGIN_MESSAGE_MAP(CMakeStickApp, CWinApp)
	//{{AFX_MSG_MAP(CMakeStickApp)
		// HINWEIS - Hier werden Mapping-Makros vom Klassen-Assistenten eingefgt und entfernt.
		//    Innerhalb dieser generierten Quelltextabschnitte NICHTS VERNDERN!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()


CMakeStickApp::CMakeStickApp() : CWinApp("MakeStick")
{
  SetRegistryKey("GermanTeam");
}


CMakeStickApp theApp;


BOOL CMakeStickApp::InitInstance()
{
  if (instanceChecker.PreviousInstanceRunning())
  {
    instanceChecker.ActivatePreviousInstance();
	  return FALSE;
  }

  CString sPathName = AfxGetApp()->m_pszHelpFilePath;
  sPathName = sPathName.Left(sPathName.ReverseFind('\\')); // remove \MakeStick.exe
  SetCurrentDirectory(sPathName);
	CMakeStickDlg dlg;
	m_pMainWnd = &dlg;
	dlg.DoModal();
	return FALSE;
}


/*
 * Changelog:
 *
 * $Log: MakeStick.cpp,v $
 * Revision 1.2  2004/06/17 09:19:53  roefer
 * MakeStick starts only a single instance
 *
 * Revision 1.1.1.1  2004/05/22 17:15:14  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/02/19 17:16:13  tim
 * Added support for zipped sticks (GT as well as CMU)
 *
 * Revision 1.2  2004/01/17 15:16:12  roefer
 * MakeStick inserted into project
 *
 * Revision 1.1  2004/01/17 14:13:12  roefer
 * MakeStick inserted into project
 *
 * Revision 1.1  2003/05/30 13:10:20  timrie
 * new file
 *
 */
