#!/bin/bash
#this will start a router for up to two 4-robot-teams

export PATH="/usr/local/bin:$PATH"
export GT_DIR=`pwd |sed 's@\(.*\)/Bin.*@\1@' |sed 's@/cygdrive/\(.\)\(.*\)@\1:\2@'`
OBJECTCFG=MS/OPEN-R/MW/CONF/OBJECT.CFG
CONNECTCFG=MS/OPEN-R/MW/CONF/CONNECT.CFG
PORTCFG=MS/OPEN-R/MW/CONF/HOSTGW.CFG
IPTXT=ip.txt

if test x$OSTYPE = xcygwin; then
  cd "$GT_DIR/Bin"
fi
mkdir -p MS/OPEN-R/MW/CONF

HELP=0

# any parameters given? Then recreate all files
if test ! $1x = x; then

  # defaults
  TEAM1=gt4
  TEAM2=gt4
  GM=0
  ERROR=0
  PING=0
    
  # parse options
  CONT=1
  while test $CONT = 1; do
    case $1x in
      -helpx)
        shift
        HELP=1
        ;;
      -pingx)
        shift
        PING=1
        ;;
      -gmx)
        shift
        GM=1
        ;;
      -team1x)
        shift
        TEAM1=$1
        shift
        ;;
      -team2x)
        shift
        TEAM2=$1
        shift
        ;;
      *)
        CONT=0
        ;;
    esac
  done
  
  if ! test -f connect.$TEAM1 -a -f hostgw.$TEAM1; then
    echo "Error: connect.$TEAM1 or hostgw.$TEAM1 is missing. you cant use '$TEAM1' as team1"
    exit
  fi
  
  if ! test -f connect.$TEAM2 -a -f hostgw.$TEAM2; then
    echo "Error: connect.$TEAM2 or hostgw.$TEAM2 is missing. you cant use '$TEAM2' as team2"
    exit
  fi

  rm -f $OBJECTCFG
  touch $OBJECTCFG
  if test $TEAM1 = cm2 -o $TEAM2 = cm2; then
    if test x$OSTYPE = xcygwin; then
      echo "/MS/OPEN-R/MW/OBJS/Router.exe" >$OBJECTCFG
    else
      echo "/MS/OPEN-R/MW/OBJS/Router-bin" >$OBJECTCFG
    fi
  fi
  if test $GM = 1; then
    echo "/MS/OPEN-R/MW/OBJS/RGC.BIN" >>$OBJECTCFG
  fi

  # a.b.c d... format?
  if test ! $2x = x; then
    NET=$1.
    shift
  else
    NET=
  fi

  rm -f $IPTXT
  rm -f $PORTCFG
  rm -f $CONNECTCFG

  # first pass
  NUMBER=0
  AIBO=A
	for IP in $*; do
    if test ! $IP = .; then
  	  TMPL=$[NUMBER%4+1]
  	  if test ! $TMPL = $[NUMBER+1]; then
  	    AIBO=B
  	    TEAM1=$TEAM2
  	  fi
  		if test $PING = 0 || test "`ping -w 500 -n 1 $NET$IP | grep "100%"`x" = "x"; then
    		echo $NET$IP >>$IPTXT
    		grep "%$TMPL" connect.$TEAM1 | sed "s! # %$TMPL!!g" | sed "s!%A!$AIBO!g" >>$CONNECTCFG
    		grep "%$TMPL" hostgw.$TEAM1 | sed "s! # %$TMPL!!g" | sed "s!%A!$AIBO!g" | sed "s!%IP!%IP$AIBO!g" >>$PORTCFG
        if test $GM = 1; then
      	  grep RoboCupGameController connect.$TEAM1 | sed "s!%A!$AIBO!g"  | sed "s!%N!$TMPL!g" >>$CONNECTCFG
      	  grep 1070 hostgw.$TEAM1 | sed "s!%A!$AIBO!g"  | sed "s!%N!$TMPL!g" | sed "s!%IP!%IP$AIBO$TMPL!g" >>$PORTCFG
      	fi
      else
        echo $NET$IP not reachable.
        ERROR=1
      fi
    else
      echo "---" >>$IPTXT
    fi
		NUMBER=$[$NUMBER+1]
	done

  # exit on error
  if test $ERROR = 1; then
    exit 1
  fi
  
	while test $[$NUMBER < 8] = 1; do
    echo "---" >>$IPTXT
		NUMBER=$[$NUMBER+1]
  done

  # second pass: fill in IP addresses
  NUMBER=0
  AIBO=A
	for IP in $*; do
    if test ! $IP = .; then
  	  TMPL=$[NUMBER%4+1]
  	  if test ! $TMPL = $[NUMBER+1]; then
  	    AIBO=B
  	  fi
  	  sed <$PORTCFG "s!%IP$AIBO$TMPL!$NET$IP!g" >hostgw.tmp
  	  mv hostgw.tmp $PORTCFG
  	fi
		NUMBER=$[$NUMBER+1]
  done
fi

if test ! -f $PORTCFG || test ! -f $OBJECTCFG || test ! -f $CONNECTCFG || test $HELP = 1; then
  echo "usage: start.bash [-help] | [-gm] [-team1 [cm2|cm3|unsw3|gt3|gt4]] [-team2 [cm2|cm3|unsw3|gt3|gt4]] [ IP | subnet A1 [A2 [A3 [A4 [B1 [B2 [B3 [B4]]]]]]] ]"
  echo "  where -help   : prints this text"
  echo "        -ping   : use ping to check presence of robots"
  echo "        -gm     : starts the RoboCupGameController"
  echo "        -team1 X: uses team X instead of default 'gt4', (gt3,gt4,cm2,cm3,unsw3)"
  echo "        -team2 X: uses team X instead of default 'gt4', (gt3,gt4,cm2,cm3,unsw3)"
  echo "        subnet  : shared subnet for all robots followed by .Ai or .Bi"
  echo "        Ai      : own robot IP addresses"
  echo "                  can be filled up with '.' if less then 4 robots"
  echo "        Bi      : opponent robot IP addresses"
  echo "example1: start.bash                   //uses old $PORTCFG"
  echo "example2: start.bash -gm 10.0.1.100"
  echo "example3: start.bash 10.0.1 100 101"
  echo "example4: start.bash -gm 10.0.1 100 101 102 . 110 111 112"
else
  ./stop.bash
  if test x$OSTYPE = xcygwin; then
    ipc-daemon2&
    sleep 1
  fi
  /usr/local/OPEN_R_SDK/RP_OPEN_R/bin/start-rp-openr
  ./stop.bash
fi

#
# Change Log:
#
# $Log: start.bash,v $
# Revision 1.1.1.1  2004/05/22 17:10:24  cvsadm
# created new repository GT2004_WM
#
# Revision 1.12  2004/04/03 10:22:34  dueffert
# support for two teams added; GT_DIR bug fixed
#
# Revision 1.11  2004/04/01 21:13:18  roefer
# GermanTeam 2004 is default now
#
# Revision 1.11  2004/04/01 18:20:12  roefer
# GermanTeam 2004 is default now
#
# Revision 1.10  2004/03/09 08:43:57  dueffert
# new cygipc; parameterless bug fixed
#
# Revision 1.9  2004/01/16 16:17:17  thomas
# added: support for connecting with unsw-sticks
#
# Revision 1.8  2004/01/12 16:01:34  roefer
# ERS7 configurations are not required anymore
#
# Revision 1.7  2004/01/04 17:27:56  roefer
# Adaptation to new communication scheme
#
# Revision 1.6  2003/12/31 00:09:12  roefer
# Path reset to OPEN_R_SDK_ERS210 before executing
#
# Revision 1.5  2003/12/16 20:39:09  roefer
# -noping -> -ping
#
# Revision 1.4  2003/12/12 20:11:05  roefer
# Missing amp added
#
# Revision 1.3  2003/12/12 18:11:42  roefer
# ping and CMPack'03 support added
#
# Revision 1.2  2003/12/12 14:01:03  roefer
# start.bash completely rewritten
#
# Revision 1.1  2003/10/07 10:16:56  cvsadm
# Created GT2004 (M.J.)
#
# Revision 1.5  2003/09/30 11:05:33  dueffert
# typos fixed
#
# Revision 1.4  2003/09/27 14:03:26  juengel
# Removed absolute paths.
#
# Revision 1.3  2003/07/03 21:29:36  dueffert
# release support improved
#
# Revision 1.2  2003/07/03 08:10:04  dueffert
# release support added, beautified
#
# Revision 1.18  2003/05/29 20:24:17  roefer
# Previous checkin had wrong line endings
#
# Revision 1.17  2003/05/29 20:03:20  roefer
# Minor bug fixed
#
# Revision 1.16  2003/05/29 19:36:38  roefer
# Support for CMU added
#
# Revision 1.15  2003/04/28 10:40:48  roefer
# Using /bin/bash instead of /bin/sh
#
# Revision 1.14  2003/04/28 08:51:13  dueffert
# bugs fixed
#
# Revision 1.13  2003/04/16 06:56:57  roefer
# SimGT2003 problem fixed
#
# Revision 1.12  2003/04/07 22:15:42  timrie
# Added support for Linux:
#   - All filenames are case-sensitive on Linux, so they must be capitalized
#   - Different name of router-binary (there is no .exe on Linux)
#   - There is no ipc-daemon on Linux
#
# Revision 1.11  2003/04/07 20:28:31  roefer
# ip.txt has to be stored in Bin directory
#
# Revision 1.10  2003/03/25 13:45:19  dueffert
# RoboCupGameManager ist called RoboCupGameController now
#
# Revision 1.9  2003/03/21 23:25:42  dueffert
# GameManager2003 added
#
# Revision 1.8  2003/02/05 12:03:54  dueffert
# no message
#
# Revision 1.7  2003/02/04 14:10:31  wachter
# creation of hostgw.cfg corrected  - router now also works with 3 robots
#
# Revision 1.6  2002/12/07 18:45:50  roefer
# mkdir moved
#
# Revision 1.5  2002/10/24 12:28:41  roefer
# OPENR_LINUX_NO_WAIT no longer required
#
# Revision 1.4  2002/10/07 16:39:44  dueffert
# nearly works with SDK
#
# Revision 1.3  2002/10/07 16:37:56  dueffert
# nearly works with SDK
#
# Revision 1.2  2002/09/17 23:52:16  loetzsch
# no message
#
# Revision 1.1  2002/09/09 15:36:53  cvsadm
# no message
#
# Revision 1.13  2002/09/01 21:49:39  roefer
# Again
#
# Revision 1.12  2002/09/01 21:48:32  roefer
# -$GM -> -gm
#
# Revision 1.11  2002/08/16 13:38:37  roefer
# New ./oobjectManager can start without pressing enter
#
# Revision 1.10  2002/07/24 16:18:40  roefer
# start.bash generates object.cfg now and has new parameter -gm
#
# Revision 1.9  2002/06/09 14:20:37  Thomas Rfer
# Ports corrected
#
# Revision 1.8  2002/06/09 10:26:15  Thomas Rfer
# Multi router
#
# Revision 1.7  2002/06/01 10:18:58  juengel
# no message
#
# Revision 1.6  2002/05/28 14:17:01  roefer
# Sender for GameControlData removed
#
# Revision 1.5  2002/05/28 13:51:37  dueffert
# $IPTXT, connect.cfg, port.cfg are generated now
#
#
