#/bin/sh
#
# This script imports the GT200x directory to a cvs repository
# 
# The cvs.exe has to be in the PATH variable
# 


# change this to the repository name you want to import

export REPOSITORY_NAME=GT2004_WM


# change this to the cvsroot

export CVSROOT=:ext:cvsadm@tamara.informatik.hu-berlin.de:/home/cvsroot
#export CVSROOT=//clara/sharedDocs/CVS


# change this to the authentication method

export CVS_RSH=ssh2


# Remove all CVS directories

echo Deleting all 'CVS' directories.
rm -rf `find -type d | grep '/CVS' `


# Remove everything listed in cvs_ignore.bash

echo Deleting everything listed in .cvsignore files.
bash .remove_everything_listed_in_cvs_ignore.bash >& /dev/null


# Imports the module. Please add all file extensions that shall be imported binary.

echo Importing directory `pwd` to $REPOSITORY_NAME
cvs import -I !	\
-W "*.lib -k 'b'" \
-W "*.dll -k 'b'" \
-W "dot -k 'b'" \
-W "*.jar -k 'b'" \
-W "*.aps -k 'b'" \
-W "*.psd -k 'b'" \
-W "*.bmp -k 'b'" \
-W "*.ico -k 'b'" \
-W "*.exe -k 'b'" \
-W "*.wav -k 'b'" \
-W "*.reg -k 'b'" \
-W "*.ke3 -k 'b'" \
-W "*.pdf -k 'b'" \
-W "*.dat -k 'b'" \
-W "*.bin -k 'b'" \
-W "*.tsl -k 'b'" \
-W "*.c32 -k 'b'" \
-W "*.cy -k 'b'" \
-W "*.cv -k 'b'" \
-W "*.cu -k 'b'" \
-W "*.img -k 'b'" \
-W "*.c64 -k 'b'" \
-W "*.tab -k 'b'" \
-m "created new repository $REPOSITORY_NAME" $REPOSITORY_NAME avendor arelease

#
# Change Log:
#
# $Log: .import_to_cvs.bash,v $
# Revision 1.3  2004/05/23 20:14:14  loetzsch
# added .pdf and .bin extensions
#
# Revision 1.2  2004/05/22 18:26:27  loetzsch
# added ".tab"
#
# Revision 1.1.1.1  2004/05/22 17:10:23  cvsadm
# created new repository GT2004_WM
#
#
