/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;

public class FastRenderer
extends JPanel {
    private int state = 1;
    public static final int RAW = 1;
    public static final int SEGMENTED = 0;
    private Dimension appDimension;
    private Dimension drawDimension;
    private Graphics2D graphics;
    private Graphics2D offgraph;
    private BufferedImage offscreen;
    private Toolkit toolkit;
    private JPanel container;
    private boolean enabled = true;
    private Image rawImage;
    private MemoryImageSource source;
    private int drawWidth;
    private int drawHeight;
    private int[] pix;
    private AIBOFilter[] filters;
    private int[] index;
    private boolean[] bind;
    private int filterIndex = 0;
    private YUV2RGB rgbFilter;
    private byte[] controlData;
    private float sizeRatio;

    public void draw(byte[] byArray) {
        if (this.enabled) {
            if (this.state == 0) {
                int n = 0;
                while (n < this.drawWidth * this.drawHeight) {
                    int n2;
                    int n3;
                    int n4;
                    int n5 = 0xFF & byArray[n];
                    switch (n5) {
                        case 64: {
                            n4 = 200;
                            n3 = 0;
                            n2 = 0;
                            break;
                        }
                        case 1: {
                            n4 = 210;
                            n3 = 110;
                            n2 = 0;
                            break;
                        }
                        case 4: {
                            n4 = 0;
                            n3 = 130;
                            n2 = 190;
                            break;
                        }
                        case 128: {
                            n4 = 0;
                            n3 = 0;
                            n2 = 200;
                            break;
                        }
                        case 2: {
                            n4 = 190;
                            n3 = 190;
                            n2 = 0;
                            break;
                        }
                        case 16: {
                            n4 = 190;
                            n3 = 190;
                            n2 = 190;
                            break;
                        }
                        case 32: {
                            n4 = 0;
                            n3 = 150;
                            n2 = 0;
                            break;
                        }
                        case 8: {
                            n4 = 190;
                            n3 = 0;
                            n2 = 130;
                            break;
                        }
                        default: {
                            n4 = 0;
                            n3 = 0;
                            n2 = 0;
                        }
                    }
                    this.pix[n] = 0xFF000000 | n4 << 16 | n3 << 8 | n2;
                    ++n;
                }
                this.source = new MemoryImageSource(this.drawWidth, this.drawHeight, this.pix, 0, this.drawWidth);
                this.rawImage = this.createImage(this.source);
                this.repaint();
            } else {
                int n;
                int n6;
                byte[] byArray2 = byArray;
                if (this.filterIndex != 0) {
                    n6 = this.index[this.filterIndex - 1];
                    byArray2 = this.filters[n6].filter(byArray2, this.drawWidth, this.drawHeight);
                    n = n6 + 1;
                    while (this.bind[n]) {
                        byArray2 = this.filters[n].filter(byArray2, this.drawWidth, this.drawHeight);
                        ++n;
                    }
                } else {
                    byArray2 = this.rgbFilter.filter(byArray2, this.drawWidth, this.drawHeight);
                }
                int n7 = 0;
                while (n7 < this.drawWidth * this.drawHeight) {
                    n6 = 0xFF & byArray2[3 * n7];
                    n = 0xFF & byArray2[3 * n7 + 1];
                    int n8 = 0xFF & byArray2[3 * n7 + 2];
                    this.pix[n7] = 0xFF000000 | n6 << 16 | n << 8 | n8;
                    ++n7;
                }
                this.source = new MemoryImageSource(this.drawWidth, this.drawHeight, this.pix, 0, this.drawWidth);
                this.rawImage = this.createImage(this.source);
                this.repaint();
            }
        }
    }

    public int getWidth() {
        return this.appDimension.width;
    }

    public int getHeight() {
        return this.appDimension.height;
    }

    public void drawObjectTraces(Graphics graphics) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.controlData);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            if (n != 0) {
                n2 = (int)((float)n2 * this.sizeRatio);
                n3 = (int)((float)n3 * this.sizeRatio);
                n4 = (int)((float)n4 * this.sizeRatio);
                n5 = (int)((float)n5 * this.sizeRatio);
                graphics.setColor(Color.orange);
                graphics.drawRect(n2, n4, n3 - n2, n5 - n4);
                graphics.drawRect(n2 - 1, n4 - 1, n3 - n2 + 2, n5 - n4 + 2);
            }
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            int n8 = dataInputStream.readInt();
            int n9 = dataInputStream.readInt();
            int n10 = dataInputStream.readInt();
            if (n6 != 0) {
                n7 = (int)((float)n7 * this.sizeRatio);
                n8 = (int)((float)n8 * this.sizeRatio);
                n9 = (int)((float)n9 * this.sizeRatio);
                n10 = (int)((float)n10 * this.sizeRatio);
                graphics.setColor(Color.yellow);
                graphics.drawRect(n7, n9, n8 - n7, n10 - n9);
                graphics.drawRect(n7 - 1, n9 - 1, n8 - n7 + 2, n10 - n9 + 2);
            }
            int n11 = dataInputStream.readInt();
            int n12 = dataInputStream.readInt();
            int n13 = dataInputStream.readInt();
            int n14 = dataInputStream.readInt();
            int n15 = dataInputStream.readInt();
            if (n11 != 0) {
                n12 = (int)((float)n12 * this.sizeRatio);
                n13 = (int)((float)n13 * this.sizeRatio);
                n14 = (int)((float)n14 * this.sizeRatio);
                n15 = (int)((float)n15 * this.sizeRatio);
                graphics.setColor(Color.cyan);
                graphics.drawRect(n12, n14, n13 - n12, n15 - n14);
                graphics.drawRect(n12 - 1, n14 - 1, n13 - n12 + 2, n15 - n14 + 2);
            }
            int n16 = dataInputStream.readInt();
            int n17 = dataInputStream.readInt();
            int n18 = dataInputStream.readInt();
            int n19 = dataInputStream.readInt();
            int n20 = dataInputStream.readInt();
            int n21 = dataInputStream.readInt();
            int n22 = dataInputStream.readInt();
            int n23 = dataInputStream.readInt();
            int n24 = dataInputStream.readInt();
            int n25 = dataInputStream.readInt();
            if (n16 != 0) {
                n17 = (int)((float)n17 * this.sizeRatio);
                n18 = (int)((float)n18 * this.sizeRatio);
                n19 = (int)((float)n19 * this.sizeRatio);
                n20 = (int)((float)n20 * this.sizeRatio);
                n21 = (int)((float)n21 * this.sizeRatio);
                n22 = (int)((float)n22 * this.sizeRatio);
                n23 = (int)((float)n23 * this.sizeRatio);
                n24 = (int)((float)n24 * this.sizeRatio);
                graphics.setColor(Color.pink);
                graphics.drawRect(n17, n19, n18 - n17, n20 - n19);
                graphics.setColor(Color.yellow);
                graphics.drawRect(n21, n23, n22 - n21, n24 - n23);
                graphics.drawString(Integer.toString(n25), n21, n24);
            }
            int n26 = dataInputStream.readInt();
            int n27 = dataInputStream.readInt();
            int n28 = dataInputStream.readInt();
            int n29 = dataInputStream.readInt();
            int n30 = dataInputStream.readInt();
            int n31 = dataInputStream.readInt();
            int n32 = dataInputStream.readInt();
            int n33 = dataInputStream.readInt();
            int n34 = dataInputStream.readInt();
            int n35 = dataInputStream.readInt();
            if (n26 != 0) {
                n27 = (int)((float)n27 * this.sizeRatio);
                n28 = (int)((float)n28 * this.sizeRatio);
                n29 = (int)((float)n29 * this.sizeRatio);
                n30 = (int)((float)n30 * this.sizeRatio);
                n31 = (int)((float)n31 * this.sizeRatio);
                n32 = (int)((float)n32 * this.sizeRatio);
                n33 = (int)((float)n33 * this.sizeRatio);
                n34 = (int)((float)n34 * this.sizeRatio);
                graphics.setColor(Color.yellow);
                graphics.drawRect(n27, n29, n28 - n27, n30 - n29);
                graphics.setColor(Color.pink);
                graphics.drawRect(n31, n33, n32 - n31, n34 - n33);
                graphics.drawString(Integer.toString(n35), n31, n34);
            }
            int n36 = dataInputStream.readInt();
            int n37 = dataInputStream.readInt();
            int n38 = dataInputStream.readInt();
            int n39 = dataInputStream.readInt();
            int n40 = dataInputStream.readInt();
            int n41 = dataInputStream.readInt();
            int n42 = dataInputStream.readInt();
            int n43 = dataInputStream.readInt();
            int n44 = dataInputStream.readInt();
            int n45 = dataInputStream.readInt();
            if (n36 != 0) {
                n37 = (int)((float)n37 * this.sizeRatio);
                n38 = (int)((float)n38 * this.sizeRatio);
                n39 = (int)((float)n39 * this.sizeRatio);
                n40 = (int)((float)n40 * this.sizeRatio);
                n41 = (int)((float)n41 * this.sizeRatio);
                n42 = (int)((float)n42 * this.sizeRatio);
                n43 = (int)((float)n43 * this.sizeRatio);
                n44 = (int)((float)n44 * this.sizeRatio);
                graphics.setColor(Color.pink);
                graphics.drawRect(n37, n39, n38 - n37, n40 - n39);
                graphics.setColor(Color.green);
                graphics.drawRect(n41, n43, n42 - n41, n44 - n43);
                graphics.drawString(Integer.toString(n45), n41, n44);
            }
            int n46 = dataInputStream.readInt();
            int n47 = dataInputStream.readInt();
            int n48 = dataInputStream.readInt();
            int n49 = dataInputStream.readInt();
            int n50 = dataInputStream.readInt();
            int n51 = dataInputStream.readInt();
            int n52 = dataInputStream.readInt();
            int n53 = dataInputStream.readInt();
            int n54 = dataInputStream.readInt();
            int n55 = dataInputStream.readInt();
            if (n46 != 0) {
                n47 = (int)((float)n47 * this.sizeRatio);
                n48 = (int)((float)n48 * this.sizeRatio);
                n49 = (int)((float)n49 * this.sizeRatio);
                n50 = (int)((float)n50 * this.sizeRatio);
                n51 = (int)((float)n51 * this.sizeRatio);
                n52 = (int)((float)n52 * this.sizeRatio);
                n53 = (int)((float)n53 * this.sizeRatio);
                n54 = (int)((float)n54 * this.sizeRatio);
                graphics.setColor(Color.green);
                graphics.drawRect(n47, n49, n48 - n47, n50 - n49);
                graphics.setColor(Color.pink);
                graphics.drawRect(n51, n53, n52 - n51, n54 - n53);
                graphics.drawString(Integer.toString(n55), n51, n54);
            }
            int n56 = dataInputStream.readInt();
            int n57 = dataInputStream.readInt();
            int n58 = dataInputStream.readInt();
            int n59 = dataInputStream.readInt();
            int n60 = dataInputStream.readInt();
            int n61 = dataInputStream.readInt();
            int n62 = dataInputStream.readInt();
            int n63 = dataInputStream.readInt();
            int n64 = dataInputStream.readInt();
            int n65 = dataInputStream.readInt();
            if (n56 != 0) {
                n57 = (int)((float)n57 * this.sizeRatio);
                n58 = (int)((float)n58 * this.sizeRatio);
                n59 = (int)((float)n59 * this.sizeRatio);
                n60 = (int)((float)n60 * this.sizeRatio);
                n61 = (int)((float)n61 * this.sizeRatio);
                n62 = (int)((float)n62 * this.sizeRatio);
                n63 = (int)((float)n63 * this.sizeRatio);
                n64 = (int)((float)n64 * this.sizeRatio);
                graphics.setColor(Color.pink);
                graphics.drawRect(n57, n59, n58 - n57, n60 - n59);
                graphics.setColor(Color.cyan);
                graphics.drawRect(n61, n63, n62 - n61, n64 - n63);
                graphics.drawString(Integer.toString(n65), n61, n64);
            }
            int n66 = dataInputStream.readInt();
            int n67 = dataInputStream.readInt();
            int n68 = dataInputStream.readInt();
            int n69 = dataInputStream.readInt();
            int n70 = dataInputStream.readInt();
            int n71 = dataInputStream.readInt();
            int n72 = dataInputStream.readInt();
            int n73 = dataInputStream.readInt();
            int n74 = dataInputStream.readInt();
            int n75 = dataInputStream.readInt();
            if (n66 != 0) {
                n67 = (int)((float)n67 * this.sizeRatio);
                n68 = (int)((float)n68 * this.sizeRatio);
                n69 = (int)((float)n69 * this.sizeRatio);
                n70 = (int)((float)n70 * this.sizeRatio);
                n71 = (int)((float)n71 * this.sizeRatio);
                n72 = (int)((float)n72 * this.sizeRatio);
                n73 = (int)((float)n73 * this.sizeRatio);
                n74 = (int)((float)n74 * this.sizeRatio);
                graphics.setColor(Color.cyan);
                graphics.drawRect(n67, n69, n68 - n67, n70 - n69);
                graphics.setColor(Color.pink);
                graphics.drawRect(n71, n73, n72 - n71, n74 - n73);
                graphics.drawString(Integer.toString(n75), n71, n74);
            }
            int n76 = dataInputStream.readInt();
            int n77 = dataInputStream.readInt();
            int n78 = dataInputStream.readInt();
            int n79 = dataInputStream.readInt();
            int n80 = dataInputStream.readInt();
            int n81 = dataInputStream.readInt();
            if (n76 != 0) {
                n77 = (int)((float)n77 * this.sizeRatio);
                n78 = (int)((float)n78 * this.sizeRatio);
                n79 = (int)((float)n79 * this.sizeRatio);
                n80 = (int)((float)n80 * this.sizeRatio);
                graphics.setColor(Color.red.brighter());
                graphics.drawRect(n77, n79, n78 - n77, n80 - n79);
                graphics.drawString(Integer.toString(n81), n77, n80);
            }
            int n82 = dataInputStream.readInt();
            int n83 = dataInputStream.readInt();
            int n84 = dataInputStream.readInt();
            int n85 = dataInputStream.readInt();
            int n86 = dataInputStream.readInt();
            int n87 = dataInputStream.readInt();
            if (n82 != 0) {
                n83 = (int)((float)n83 * this.sizeRatio);
                n84 = (int)((float)n84 * this.sizeRatio);
                n85 = (int)((float)n85 * this.sizeRatio);
                n86 = (int)((float)n86 * this.sizeRatio);
                graphics.setColor(Color.red.brighter());
                graphics.drawRect(n83, n85, n84 - n83, n86 - n85);
                graphics.drawString(Integer.toString(n87), n83, n86);
            }
            int n88 = dataInputStream.readInt();
            int n89 = dataInputStream.readInt();
            int n90 = dataInputStream.readInt();
            int n91 = dataInputStream.readInt();
            int n92 = dataInputStream.readInt();
            int n93 = dataInputStream.readInt();
            if (n88 != 0) {
                n89 = (int)((float)n89 * this.sizeRatio);
                n90 = (int)((float)n90 * this.sizeRatio);
                n91 = (int)((float)n91 * this.sizeRatio);
                n92 = (int)((float)n92 * this.sizeRatio);
                graphics.setColor(Color.red.brighter());
                graphics.drawRect(n89, n91, n90 - n89, n92 - n91);
                graphics.drawString(Integer.toString(n93), n89, n92);
            }
            int n94 = dataInputStream.readInt();
            int n95 = dataInputStream.readInt();
            int n96 = dataInputStream.readInt();
            int n97 = dataInputStream.readInt();
            int n98 = dataInputStream.readInt();
            int n99 = dataInputStream.readInt();
            if (n94 != 0) {
                n95 = (int)((float)n95 * this.sizeRatio);
                n96 = (int)((float)n96 * this.sizeRatio);
                n97 = (int)((float)n97 * this.sizeRatio);
                n98 = (int)((float)n98 * this.sizeRatio);
                graphics.setColor(Color.red.brighter());
                graphics.drawRect(n95, n97, n96 - n95, n98 - n97);
                graphics.drawString(Integer.toString(n99), n95, n98);
            }
            int n100 = dataInputStream.readInt();
            int n101 = dataInputStream.readInt();
            graphics.setColor(Color.white);
            graphics.drawString("WX: " + n100 + " WY: " + n101, 0, this.drawDimension.height);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setControlData(byte[] byArray) {
        this.controlData = byArray;
    }

    public JPanel getContainer() {
        return this.container;
    }

    public void paint(Graphics graphics) {
        if (this.enabled) {
            if (this.rawImage == null) {
                graphics.fillRect(0, 0, this.drawDimension.width, this.drawDimension.height);
            } else {
                graphics.drawImage(this.rawImage, 0, 0, this.drawDimension.width, this.drawDimension.height, this);
            }
            if (AIBOVision.segmented) {
                this.drawObjectTraces(graphics);
            }
            this.toolkit.sync();
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setDimension(int n, int n2) {
        this.drawWidth = n;
        this.drawHeight = n2;
        this.drawDimension = new Dimension((int)(this.sizeRatio * (float)n), (int)(this.sizeRatio * (float)n2));
    }

    public Dimension getMinimumSize() {
        return this.appDimension;
    }

    public Dimension getPreferredSize() {
        return this.appDimension;
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void setZoomFactor(float f) {
        this.sizeRatio = f;
        this.drawDimension = new Dimension((int)(this.sizeRatio * (float)this.drawWidth), (int)(this.sizeRatio * (float)this.drawHeight));
    }

    public void setState(int n) {
        this.state = n;
    }

    public void setFilters(AIBOFilter[] aIBOFilterArray, int[] nArray, boolean[] blArray) {
        this.filters = aIBOFilterArray;
        this.index = nArray;
        this.bind = blArray;
    }

    public void setSelectedFilter(int n) {
        this.filterIndex = n;
    }

    public FastRenderer(int n, int n2, int n3, int n4, float f) {
        this.sizeRatio = f;
        this.drawWidth = n3;
        this.drawHeight = n4;
        this.container = new JPanel();
        this.container.setBorder(new SoftBevelBorder(1));
        this.toolkit = this.getToolkit();
        this.appDimension = new Dimension(n, n2);
        this.drawDimension = new Dimension((int)(this.sizeRatio * (float)n3), (int)(this.sizeRatio * (float)n4));
        this.pix = new int[n3 * n4];
        int n5 = -16777216;
        int n6 = 0;
        while (n6 < n3 * n4) {
            this.pix[n6] = n5;
            ++n6;
        }
        this.source = new MemoryImageSource(n3, n4, this.pix, 0, n3);
        this.rawImage = this.createImage(this.source);
        this.rgbFilter = new YUV2RGB();
        this.setDoubleBuffered(true);
        this.container.add(this);
    }
}

