/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;

public class Display
extends JPanel {
    private String identifier = "";
    private Dimension dimension;
    private Graphics2D graphics;
    private Graphics2D offgraph;
    private BufferedImage offscreen;
    private Toolkit toolkit;
    private JPanel container;
    private boolean enabled = true;
    private BufferedImage rawImage;
    private int width;
    private int height;
    private int[] pix;
    private float sizeRatio;

    public void draw(BufferedImage bufferedImage) {
        if (this.enabled) {
            this.rawImage = bufferedImage;
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        return this.dimension;
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void setID(String string) {
        this.identifier = string;
    }

    public String getID() {
        return this.identifier;
    }

    public int getWidth() {
        return this.dimension.width;
    }

    public int getHeight() {
        return this.dimension.height;
    }

    public JPanel getContainer() {
        return this.container;
    }

    public void paint(Graphics graphics) {
        if (this.enabled) {
            if (this.rawImage == null) {
                graphics.fillRect(0, 0, this.dimension.width, this.dimension.height);
            } else {
                graphics.drawImage(this.rawImage, 0, 0, this.dimension.width, this.dimension.height, this);
            }
            this.toolkit.sync();
        }
    }

    public void setZoomFactor(float f) {
        this.sizeRatio = f;
        this.dimension = new Dimension((int)(this.sizeRatio * (float)this.width), (int)(this.sizeRatio * (float)this.height));
    }

    public float getZoomFactor() {
        return this.sizeRatio;
    }

    public void setDimension(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.dimension = new Dimension((int)(this.sizeRatio * (float)n), (int)(this.sizeRatio * (float)n2));
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Display(int n, int n2, float f) {
        this.width = n;
        this.height = n2;
        this.sizeRatio = f;
        this.container = new JPanel();
        this.container.setBorder(new SoftBevelBorder(1));
        this.toolkit = this.getToolkit();
        this.dimension = new Dimension((int)(this.sizeRatio * (float)n), (int)(this.sizeRatio * (float)n2));
        this.pix = new int[n * n2];
        this.rawImage = new BufferedImage(n, n2, 2);
        this.setDoubleBuffered(true);
        this.setPreferredSize(this.dimension);
        this.container.add(this);
    }
}

