<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.option.xsl,v $
Revision 1.2  2004/03/10 13:31:12  dueffert
bug fixed: duplicate variable renamed

Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.2  2003/09/20 16:34:16  loetzsch
renamed "following-option-..." to "subsequent-option-.." and
"following-basic-behavior-.." to "subsequent-basic-behavior-.."
for consistency with publications

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.19  2003/05/12 10:26:21  loetzsch
fixed a bug in the decision tree chart

Revision 1.18  2003/05/05 17:47:54  loetzsch
added in Xabsl2:
- marking of states as target-states with attribute is-target-state="true"
- boolean expression "subsequent-option-reached-target-state"
- common-decision-tree

Revision 1.17  2003/03/25 11:25:38  loetzsch
fixed a bug in the option documentation

Revision 1.16  2003/01/18 18:45:30  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created
- The option trees are painted by using a precompiled xml file "option-tree.xml"
  to improve compile speed.

Revision 1.15  2003/01/15 14:47:35  loetzsch
some speed enhancements

Revision 1.14  2003/01/10 19:01:53  loetzsch
state circles dont have an URL attribute anymore

Revision 1.13  2002/12/09 13:02:31  loetzsch
decimal-input-function added

Revision 1.12  2002/12/08 19:31:18  loetzsch
visualization of decision trees finished

Revision 1.11  2002/12/06 21:13:37  loetzsch
Decimal input symbols can now be registered at the engine

Revision 1.10  2002/12/06 13:14:40  loetzsch
- complete decision trees
- allmost all id constraints
- decision tree pseudo code in documentation

Revision 1.9  2002/12/05 16:47:24  loetzsch
options now contain decision trees for each state

Revision 1.8  2002/12/04 19:06:46  loetzsch
some minor beautifications

Revision 1.7  2002/12/04 10:38:15  juengel
XABSL2 logo added, changed table cell structure.

Revision 1.6  2002/12/03 18:17:14  loetzsch
- predefined conditions
- stylesheets are now independend from output directory
- minor changes

Revision 1.5  2002/11/30 19:16:15  juengel
Moved BehaviorControl solution Xabsl2Berlin to Humboldt2003.

Revision 1.4  2002/11/30 13:43:53  loetzsch
option tree visualization for options and agents finished

Revision 1.3  2002/11/29 13:35:11  loetzsch
- option specification continued

Revision 1.2  2002/11/28 17:25:51  loetzsch
- added DotML to the project
- visualization for state machines first draft

Revision 1.1  2002/11/27 15:33:52  loetzsch
- first version of option and option-definitions
- started debug symbol generation
- added VALIDATION target to Makefile

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.1" xmlns:dotml="http://www.martin-loetzsch.de/DOTML">
	<xsl:import href="generate-documentation.option-tree.xsl"/>
	<xsl:import href="generate-documentation.parameters.xsl"/>
	<xsl:import href="generate-documentation.pseudo-code.xsl"/>
	<xsl:import href="generate-documentation.menu.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:param name="option-tree-xml"/>
	<xsl:key name="basic-behaviors" match="xabsl:option/xabsl:basic-behaviors/xabsl:basic-behavior" use="@name"/>
	<xsl:key name="option-definitions" match="xabsl:option/xabsl:option-definitions/xabsl:option-definition" use="@name"/>
	<xsl:key name="transitions" match="xabsl:option/descendant::xabsl:transition-to-state" use="@ref"/>
	<xsl:template match="xabsl:option">
		<xsl:variable name="name" select="@name"/>
		<xsl:variable name="description" select="xabsl:option-definitions/xabsl:option-definition[@name=$name]/@description"/>
		<html>
			<head>
				<title>XABSL2 Behavior Documentation: Option <xsl:value-of select="@name"/>
				</title>
				<link rel="stylesheet" type="text/css" href="styles.css">
					<xsl:text> </xsl:text>
				</link>
			</head>
			<body>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td class="menu-cell">
							<table border="0" cellspacing="0" cellpadding="1">
								<xsl:call-template name="menu-xabsl2-logo"/>
								<xsl:call-template name="menu-entry-index-linked"/>
								<xsl:call-template name="menu-entry-agents-linked"/>
								<xsl:call-template name="menu-entry-symbols-linked"/>
								<xsl:call-template name="menu-entry-basic-behaviors-linked"/>
								<xsl:call-template name="menu-entry-options-linked"/>
								<xsl:call-template name="menu-option"/>
							</table>
						</td>
						<td class="main-area">
							<h1>Option <xsl:value-of select="@name"/>
							</h1>
							<p>
								<xsl:value-of select="$description"/>
							</p>
							<xsl:for-each select="key('option-definitions',@name)">
								<xsl:if test="xabsl:parameter">
									<p>Parameters of that option:
								<xsl:call-template name="parameters"/>
									</p>
								</xsl:if>
							</xsl:for-each>
							<h2>State Machine</h2>
							<dotml:graph file-name="svg/option_{$name}" ranksep="0.4" nodesep="0.3">
								<dotml:cluster id="option" label="option {$name}" fontname="Arial" fontcolor="#005A9C" fontsize="12" fillcolor="#F4F4F4" style="filled">
									<xsl:call-template name="state-machine"/>
								</dotml:cluster>
								<dotml:cluster id="option_tree" color="#FFFFFF">
									<xsl:call-template name="paint-option-tree">
										<xsl:with-param name="root-option" select="@name"/>
										<xsl:with-param name="dont-paint-option" select="@name"/>
										<xsl:with-param name="option-tree-xml" select="$option-tree-xml"/>
									</xsl:call-template>
									<xsl:for-each select="xabsl:state/xabsl:subsequent-basic-behavior">
										<dotml:edge arrowsize="0.8" color="#808080" style="dashed" minlen="3">
											<xsl:attribute name="from">state_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="../@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
											<xsl:attribute name="to">basic_behavior_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@ref"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
										</dotml:edge>
									</xsl:for-each>
									<xsl:for-each select="xabsl:state/xabsl:subsequent-option">
										<dotml:edge minlen="2" arrowsize="0.8" color="#808080" style="dashed">
											<xsl:attribute name="from">state_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="../@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
											<xsl:attribute name="to">option_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@ref"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
										</dotml:edge>
									</xsl:for-each>
								</dotml:cluster>
							</dotml:graph>
							<xsl:apply-templates select="xabsl:state"/>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="xabsl:state">
		<xsl:variable name="option-name" select="../@name"/>
		<xsl:variable name="current-state" select="@name"/>
		<h2 id="state.{@name}">State <xsl:value-of select="@name"/>
		</h2>
		<table cellpadding="0" cellspacing="5">
			<xsl:if test="@is-target-state='true'">
				<tr>
					<td colspan="2">This state is a target state.<br/>
						<br/>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="2">If that state is active, </td>
			</tr>
			<tr>
				<td nowrap="nowrap">
					<span class="bold">&#160;>&#160;</span>
				</td>
				<td>The <xsl:for-each select="xabsl:subsequent-option"> option <a href="option.{@ref}.html" title="{key('option-definitions',@ref)/@description}">
							<xsl:value-of select="@ref"/>
						</a>
					</xsl:for-each>
					<xsl:for-each select="xabsl:subsequent-basic-behavior">
						<xsl:variable name="ref" select="@ref"/> basic behavior <a href="basic-behaviors.{key('basic-behaviors',$ref)/../@id}.html#{$ref}" title="{key('basic-behaviors',$ref)/@description}">
							<xsl:value-of select="@ref"/>
						</a>
					</xsl:for-each> is executed. <xsl:if test="xabsl:*/xabsl:set-parameter">Parameters:</xsl:if>
				</td>
			</tr>
			<xsl:if test="xabsl:*/xabsl:set-parameter">
				<tr>
					<td>&#160;</td>
					<td>
						<table cellspacing="0" cellpadding="0">
							<xsl:for-each select="xabsl:*/xabsl:set-parameter">
								<xsl:variable name="ref" select="@ref"/>
								<xsl:variable name="subsequent" select="../@ref"/>
								<tr>
									<td nowrap="nowrap">&#160;&#160;&#160;</td>
									<td class="pseudo-code-cell">
										<xsl:if test="../../xabsl:subsequent-option">
											<a href="option.{../@ref}.html" title="{key('option-definitions',$subsequent)/xabsl:parameter[@name=$ref]/@description}">
												<xsl:value-of select="@ref"/>
											</a>
										</xsl:if>
										<xsl:if test="../../xabsl:subsequent-basic-behavior">
											<a href="basic-behaviors.{key('basic-behaviors',$subsequent)/../@id}.html#{$subsequent}" title="{key('basic-behaviors',$subsequent)/xabsl:parameter[@name=$ref]/@description}">
												<xsl:value-of select="@ref"/>
											</a>
										</xsl:if>
									</td>
									<td nowrap="nowrap" class="pseudo-code-cell">&#160;=&#160;</td>
									<td class="pseudo-code-cell">
										<xsl:apply-templates/>;</td>
								</tr>
							</xsl:for-each>
						</table>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="2">&#160;</td>
			</tr>
			<xsl:if test="xabsl:set-output-symbol">
				<tr>
					<td nowrap="nowrap">
						<span class="bold">&#160;>&#160;</span>
					</td>
					<td>These output symbols are set:</td>
				</tr>
				<tr>
					<td>&#160;</td>
					<td>
						<table cellspacing="0" cellpadding="0">
							<xsl:for-each select="xabsl:set-output-symbol">
								<xsl:variable name="ref" select="@ref"/>
								<tr>
									<td nowrap="nowrap">&#160;&#160;&#160;</td>
									<td class="pseudo-code-cell">
										<a href="symbols.{../../xabsl:symbols/xabsl:enumerated-output-symbol[@name=$ref]/../@id}.html#symbols.{$ref}" title="{../../xabsl:symbols/xabsl:enumerated-output-symbol[@name=$ref]/@description}">
											<xsl:value-of select="@ref"/>
										</a>
									</td>
									<td nowrap="nowrap" class="pseudo-code-cell">&#160;=&#160;</td>
									<td class="pseudo-code-cell">
										<xsl:value-of select="@value"/>
									</td>
								</tr>
							</xsl:for-each>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="2">&#160;</td>
				</tr>
			</xsl:if>
			<tr>
				<td colspan="2">The decision tree:</td>
			</tr>
			<tr>
				<td>&#160;</td>
				<td>
					<dotml:graph ranksep="0.4">
						<xsl:attribute name="file-name">svg/option_<xsl:value-of select="../@name"/>_state_<xsl:value-of select="@name"/></xsl:attribute>
						<dotml:cluster id="option" label="option {../@name}" fontname="Arial" fontcolor="#005A9C" fontsize="12" fillcolor="#F4F4F4" style="filled">
							<dotml:cluster id="states" style="filled" fillcolor="#F4F4F4" color="#F4F4F4">
								<xsl:for-each select=".//xabsl:transition-to-state | ../xabsl:common-decision-tree//xabsl:transition-to-state">
									<xsl:variable name="ref" select="@ref"/>
									<xsl:for-each select="ancestor::xabsl:option/xabsl:state[@name=$ref and @name!=$current-state]">
										<xsl:call-template name="paint-state-node">
											<xsl:with-param name="option-name" select="../@name"/>
										</xsl:call-template>
									</xsl:for-each>
									<xsl:for-each select="ancestor::xabsl:option/xabsl:state[@name=$ref and @name=$current-state]">
										<dotml:node label="{@name}" fontname="Arial" fontcolor="#005A9C" fontsize="9" style="dashed" fillcolor="#FFFFFF">
											<xsl:attribute name="id">state_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
											<xsl:attribute name="label"><xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">\n</xsl:with-param></xsl:call-template></xsl:attribute>
											<xsl:attribute name="shape"><xsl:choose><xsl:when test="../@initial-state=@name">Mcircle</xsl:when><xsl:when test="@is-target-state='true'">doublecircle</xsl:when><xsl:otherwise>circle</xsl:otherwise></xsl:choose></xsl:attribute>
										</dotml:node>
									</xsl:for-each>
								</xsl:for-each>
							</dotml:cluster>
							<dotml:cluster id="decision_tree" label="state {@name}" fillcolor="#FFFFFF" fontname="Arial" fontcolor="#005A9C" fontsize="12" style="filled">
								<dotml:node id="start" shape="point"/>
								<xsl:choose>
									<xsl:when test="../xabsl:common-decision-tree">
										<xsl:for-each select="../xabsl:common-decision-tree">
											<xsl:call-template name="decision-tree">
												<xsl:with-param name="parent">start</xsl:with-param>
												<xsl:with-param name="current-state" select="$current-state"/>
											</xsl:call-template>
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise>
										<xsl:for-each select="xabsl:decision-tree">
											<xsl:call-template name="decision-tree">
												<xsl:with-param name="parent">start</xsl:with-param>
												<xsl:with-param name="current-state" select="$current-state"/>
											</xsl:call-template>
										</xsl:for-each>
									</xsl:otherwise>
								</xsl:choose>
							</dotml:cluster>
						</dotml:cluster>
					</dotml:graph>
				</td>
			</tr>
			<tr>
				<td colspan="2">&#160;</td>
			</tr>
			<tr>
				<td colspan="2">Pseudo code of the decision tree:</td>
			</tr>
			<tr>
				<td>&#160;</td>
				<td>
					<xsl:choose>
						<xsl:when test="../xabsl:common-decision-tree">
							<xsl:for-each select="../xabsl:common-decision-tree">
								<xsl:call-template name="pseudo-code">
									<xsl:with-param name="current-state" select="$current-state"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="xabsl:decision-tree">
								<xsl:call-template name="pseudo-code"/>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="decision-tree">
		<xsl:param name="parent"/>
		<xsl:param name="current-state"/>
		<xsl:if test="xabsl:if">
			<dotml:record color="#FFFFFF" fontsize="9" height="0.15">
				<xsl:attribute name="fontname"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">Arial Bold Italic</xsl:when><xsl:otherwise>Arial Bold</xsl:otherwise></xsl:choose></xsl:attribute>
				<dotml:node id="{$parent}_0" label="if"/>
				<xsl:for-each select="xabsl:else-if">
					<dotml:node id="{$parent}_{count(preceding-sibling::xabsl:*)}" label="else if"/>
				</xsl:for-each>
				<xsl:for-each select="xabsl:else">
					<dotml:node id="{$parent}_{count(preceding-sibling::xabsl:*)}" label="else"/>
				</xsl:for-each>
				<xsl:if test="../xabsl:common-decision-tree">
					<dotml:node id="{$parent}_{count(child::xabsl:*)}" label="else"/>
				</xsl:if>
			</dotml:record>
			<dotml:edge from="{$parent}" to="{$parent}_0" dir="none">
				<xsl:attribute name="style"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">dashed</xsl:when><xsl:otherwise>solid</xsl:otherwise></xsl:choose></xsl:attribute>
			</dotml:edge>
			<dotml:node id="{$parent}_0_" shape="box" fontsize="9">
				<xsl:attribute name="style"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">dashed</xsl:when><xsl:otherwise>solid</xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:attribute name="fontname"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">Arial Italic</xsl:when><xsl:otherwise>Arial</xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:attribute name="label"><xsl:call-template name="add-line-breaks"><xsl:with-param name="original-string"><xsl:value-of select="xabsl:if/xabsl:condition/@description"/></xsl:with-param><xsl:with-param name="min-length">5</xsl:with-param></xsl:call-template></xsl:attribute>
			</dotml:node>
			<dotml:edge from="{$parent}_0" to="{$parent}_0_" dir="none">
				<xsl:attribute name="style"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">dashed</xsl:when><xsl:otherwise>solid</xsl:otherwise></xsl:choose></xsl:attribute>
			</dotml:edge>
			<xsl:for-each select="xabsl:if">
				<xsl:call-template name="decision-tree">
					<xsl:with-param name="parent">
						<xsl:value-of select="$parent"/>_0_</xsl:with-param>
					<xsl:with-param name="current-state" select="$current-state"/>
				</xsl:call-template>
			</xsl:for-each>
			<xsl:for-each select="xabsl:else-if">
				<dotml:node id="{$parent}_{count(preceding-sibling::xabsl:*)}_" shape="box" fontsize="9">
					<xsl:attribute name="style"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">dashed</xsl:when><xsl:otherwise>solid</xsl:otherwise></xsl:choose></xsl:attribute>
					<xsl:attribute name="fontname"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">Arial Italic</xsl:when><xsl:otherwise>Arial</xsl:otherwise></xsl:choose></xsl:attribute>
					<xsl:attribute name="label"><xsl:call-template name="add-line-breaks"><xsl:with-param name="original-string"><xsl:value-of select="xabsl:condition/@description"/></xsl:with-param><xsl:with-param name="min-length">5</xsl:with-param></xsl:call-template></xsl:attribute>
				</dotml:node>
				<dotml:edge from="{$parent}_{count(preceding-sibling::xabsl:*)}" to="{$parent}_{count(preceding-sibling::xabsl:*)}_" dir="none">
					<xsl:attribute name="style"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">dashed</xsl:when><xsl:otherwise>solid</xsl:otherwise></xsl:choose></xsl:attribute>
				</dotml:edge>
				<xsl:call-template name="decision-tree">
					<xsl:with-param name="parent">
						<xsl:value-of select="$parent"/>_<xsl:value-of select="count(preceding-sibling::xabsl:*)"/>_</xsl:with-param>
					<xsl:with-param name="current-state" select="$current-state"/>
				</xsl:call-template>
			</xsl:for-each>
			<xsl:choose>
				<xsl:when test="../xabsl:common-decision-tree">
					<xsl:variable name="p">
						<xsl:value-of select="$parent"/>_<xsl:value-of select="count(child::xabsl:*)"/>
					</xsl:variable>
					<xsl:for-each select="../xabsl:state[@name=$current-state]/xabsl:decision-tree">
						<xsl:call-template name="decision-tree">
							<xsl:with-param name="parent" select="$p"/>
							<xsl:with-param name="current-state" select="$current-state"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="xabsl:else">
						<xsl:call-template name="decision-tree">
							<xsl:with-param name="parent">
								<xsl:value-of select="$parent"/>_<xsl:value-of select="count(preceding-sibling::xabsl:*)"/>
							</xsl:with-param>
							<xsl:with-param name="current-state" select="$current-state"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="xabsl:transition-to-state">
			<dotml:edge from="{$parent}" minlen="2">
				<xsl:variable name="ref" select="xabsl:transition-to-state/@ref"/>
				<xsl:attribute name="style"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">dashed</xsl:when><xsl:otherwise>solid</xsl:otherwise></xsl:choose></xsl:attribute>
				<xsl:attribute name="to">state_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="$ref"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
			</dotml:edge>
		</xsl:if>
	</xsl:template>
	<xsl:template name="paint-state-node">
		<xsl:param name="option-name"/>
		<dotml:node label="{@name}" fontcolor="#005A9C" fontsize="9" style="filled" fillcolor="#FFFFFF" fontname="Arial">
			<xsl:attribute name="id">state_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
			<xsl:attribute name="label"><xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@name"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">\n</xsl:with-param></xsl:call-template></xsl:attribute>
			<xsl:attribute name="shape"><xsl:choose><xsl:when test="../@initial-state=@name">Mcircle</xsl:when><xsl:when test="@is-target-state='true'">doublecircle</xsl:when><xsl:otherwise>circle</xsl:otherwise></xsl:choose></xsl:attribute>
		</dotml:node>
	</xsl:template>
	<xsl:template name="state-machine">
		<xsl:variable name="name" select="@name"/>
		<dotml:sub-graph rank="same">
			<xsl:for-each select="xabsl:state[1]">
				<xsl:call-template name="paint-state-node">
					<xsl:with-param name="option-name" select="$name"/>
				</xsl:call-template>
			</xsl:for-each>
		</dotml:sub-graph>
		<xsl:for-each select="xabsl:state[position() mod 3 = 2]">
			<dotml:sub-graph rank="same">
				<xsl:call-template name="paint-state-node">
					<xsl:with-param name="option-name" select="$name"/>
				</xsl:call-template>
				<xsl:for-each select="following-sibling::xabsl:state[1]">
					<xsl:call-template name="paint-state-node">
						<xsl:with-param name="option-name" select="$name"/>
					</xsl:call-template>
				</xsl:for-each>
				<xsl:for-each select="following-sibling::xabsl:state[2]">
					<xsl:call-template name="paint-state-node">
						<xsl:with-param name="option-name" select="$name"/>
					</xsl:call-template>
				</xsl:for-each>
			</dotml:sub-graph>
		</xsl:for-each>
		<xsl:for-each select="xabsl:state">
			<xsl:variable name="name2" select="@name"/>
			<xsl:for-each select="descendant::xabsl:transition-to-state | ../xabsl:common-decision-tree/descendant::xabsl:transition-to-state">
				<xsl:if test="count(key('transitions',@ref)[ancestor::xabsl:state[@name=$name2] or ancestor::xabsl:common-decision-tree][1] | .) = 1">
					<dotml:edge>
						<xsl:attribute name="from">state_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="$name2"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
						<xsl:attribute name="to">state_<xsl:call-template name="replace-in-string"><xsl:with-param name="original-string" select="@ref"/><xsl:with-param name="replace">-</xsl:with-param><xsl:with-param name="with">_</xsl:with-param></xsl:call-template></xsl:attribute>
					</dotml:edge>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
