<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-debug-symbols.xsl,v $
Revision 1.1  2003/10/07 10:13:24  cvsadm
Created GT2004 (M.J.)

Revision 1.2  2003/09/30 10:51:11  dueffert
typos fixed

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.9  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.8  2003/01/18 18:46:29  loetzsch
- symbols, conditions and agents don't need to be added to the agents anymore.

Revision 1.7  2003/01/11 13:30:39  juengel
Added type of input symbols

Revision 1.6  2003/01/09 10:00:47  loetzsch
simplified

Revision 1.5  2003/01/08 18:46:26  loetzsch
continued

Revision 1.4  2003/01/08 15:10:09  loetzsch
started intermediate code generation

Revision 1.3  2002/12/09 16:43:11  loetzsch
now each symbol occurs only once in the debug symbols

Revision 1.2  2002/12/06 17:51:20  loetzsch
simplified

Revision 1.1  2002/11/27 15:33:52  loetzsch
- first version of option and option-definitions
- started debug symbol generation
- added VALIDATION target to Makefile

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.1">
	<xsl:output method="text"/>
	<xsl:key name="basic-behaviors" match="xabsl:agent-collection/xabsl:options/xabsl:option/xabsl:basic-behaviors/xabsl:basic-behavior" use="@name"/>
	<xsl:key name="output-symbols" match="xabsl:agent-collection/xabsl:options/xabsl:option/xabsl:symbols/xabsl:enumerated-output-symbol" use="@name"/>
	<xsl:key name="input-symbols" match="xabsl:agent-collection/xabsl:options/xabsl:option/xabsl:symbols/xabsl:decimal-input-symbol | xabsl:agent-collection/xabsl:options/xabsl:option/xabsl:symbols/xabsl:boolean-input-symbol | xabsl:agent-collection/xabsl:options/xabsl:option/xabsl:symbols/xabsl:enumerated-input-symbol" use="@name"/>
	<xsl:variable name="space">
		<xsl:text> </xsl:text>
	</xsl:variable>
	<xsl:variable name="line-break">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:template match="xabsl:agent-collection">
		<xsl:text>// Debug Symbols for the agents of </xsl:text>
		<xsl:value-of select="xabsl:title"/>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of input symbols</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:options/xabsl:option/xabsl:symbols/xabsl:*[local-name()='decimal-input-symbol' or local-name()='boolean-input-symbol' or local-name()='enumerated-input-symbol'][count(key('input-symbols',@name)[1] | .)=1])"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// input symbols</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// (decimal-input-symbol | boolean-input-symbol | enumerated-input-symbol)+</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates select="xabsl:options/xabsl:option/xabsl:symbols/xabsl:decimal-input-symbol | xabsl:options/xabsl:option/xabsl:symbols/xabsl:boolean-input-symbol | xabsl:options/xabsl:option/xabsl:symbols/xabsl:enumerated-input-symbol"/>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of output symbols</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:options/xabsl:option/xabsl:symbols/xabsl:enumerated-output-symbol[count(key('output-symbols',@name)[1] | .)=1])"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// output symbols: (name number-of-elements (element)*)+</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates select="xabsl:options/xabsl:option/xabsl:symbols/xabsl:enumerated-output-symbol"/>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of options</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:options/xabsl:option)"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>//options: option-name num-of-parameters (parameter)*)+</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates select="xabsl:options/xabsl:option"/>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>// number of basic behaviors</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="count(xabsl:options/xabsl:option/xabsl:basic-behaviors/xabsl:basic-behavior[count(key('basic-behaviors',@name)[1] | .)=1])"/>
		<xsl:value-of select="$line-break"/>
		<xsl:text>//basic behaviors: (name num-of-parameters (parameter)*)+</xsl:text>
		<xsl:value-of select="$line-break"/>
		<xsl:apply-templates select="xabsl:options/xabsl:option/xabsl:basic-behaviors/xabsl:basic-behavior"/>
		<xsl:value-of select="$line-break"/>
		<xsl:value-of select="$line-break"/>
	</xsl:template>
	<xsl:template match="xabsl:option">
			<xsl:variable name="name" select="@name"/>
			<xsl:value-of select="$name"/>
			<xsl:value-of select="$space"/>
			<xsl:value-of select="count(xabsl:option-definitions/xabsl:option-definition[@name=$name]/xabsl:parameter)"/>
			<xsl:value-of select="$space"/>
			<xsl:for-each select="xabsl:option-definitions/xabsl:option-definition[@name=$name]/xabsl:parameter">
				<xsl:value-of select="@name"/>
				<xsl:value-of select="$space"/>
			</xsl:for-each>
	</xsl:template>
	<xsl:template match="xabsl:basic-behavior">
		<xsl:if test="count(key('basic-behaviors',@name)[1] | .)=1">
			<xsl:variable name="name" select="@name"/>
			<xsl:value-of select="$name"/>
			<xsl:value-of select="$space"/>
			<xsl:value-of select="count(xabsl:parameter)"/>
			<xsl:value-of select="$space"/>
			<xsl:for-each select="xabsl:parameter">
				<xsl:value-of select="@name"/>
				<xsl:value-of select="$space"/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template match="xabsl:decimal-input-symbol">
		<xsl:if test="count(key('input-symbols',@name)[1] | .)=1">
			<xsl:text>d</xsl:text>
			<xsl:value-of select="$space"/>
			<xsl:value-of select="@name"/>
			<xsl:value-of select="$space"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="xabsl:boolean-input-symbol">
		<xsl:if test="count(key('input-symbols',@name)[1] | .)=1">
			<xsl:text>b</xsl:text>
			<xsl:value-of select="$space"/>
			<xsl:value-of select="@name"/>
			<xsl:value-of select="$space"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="xabsl:enumerated-input-symbol">
		<xsl:if test="count(key('input-symbols',@name)[1] | .)=1">
			<xsl:text>e</xsl:text>
			<xsl:value-of select="$space"/>
			<xsl:value-of select="@name"/>
			<xsl:value-of select="$space"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="xabsl:enumerated-output-symbol">
		<xsl:if test="count(key('output-symbols',@name)[1] | .)=1">
			<xsl:value-of select="@name"/>
			<xsl:value-of select="$space"/>
			<xsl:value-of select="count(xabsl:enum-element)"/>
			<xsl:value-of select="$space"/>
			<xsl:for-each select="xabsl:enum-element">
				<xsl:value-of select="@name"/>
				<xsl:value-of select="$space"/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*"/>
	<xsl:template match="text()"/>
</xsl:stylesheet>
