/**
* @file Xabsl2Tools.cpp
*
* Implementation of several helper classes for the XabslEngine.
*
* @author Martin Ltzsch
*/

#include "Xabsl2Tools.h"
#include <stdarg.h>
#include <string.h>
#include <stdio.h>

void Xabsl2ErrorHandler::error(const char* format, ...)
{
  // get the argument list
  va_list args;
  va_start(args,format);
  
  // print the expression to the buffer
  vsprintf(messageBuffer,format,args); 
  
  printError(messageBuffer);
  
  // delete the argument list
  va_end(args); 
  errorsOccurred = true;
}

void Xabsl2ErrorHandler::message(const char* format, ...)
{
  // get the argument list
  va_list args;
  va_start(args,format);
  
  // print the expression to the buffer
  vsprintf(messageBuffer,format,args); 
  
  printMessage(messageBuffer);
  
  // delete the argument list
  va_end(args); 
}

/*
* Change Log:
*
* $Log: Xabsl2Tools.cpp,v $
* Revision 1.1  2003/10/07 10:13:25  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/30 10:51:11  dueffert
* typos fixed
*
* Revision 1.2  2003/08/09 14:53:10  dueffert
* files and docu beautified
*
* Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2002/12/02 19:56:32  loetzsch
* - Xabsl2Array now seems to work for more than 1 element
* - Basic behaviors now can be registered at the engine
* - Basic behaviors have access to their parameters
*
* Revision 1.1  2002/12/01 17:54:29  loetzsch
* continued Xabsl2Engine: Xabsl2Array seems to work now
*
*/
