/**
* @file Xabsl2Agent.h
* 
* Definition of class Xabsl2Agent
*
* @author Martin Ltzsch
*/

#ifndef __Xabsl2Agent_h_
#define __Xabsl2Agent_h_

#include "Xabsl2Option.h"

/** 
* @class Xabsl2Agent
* 
* Combines some options to an agent
*
* @author Martin Ltzsch
*/
class Xabsl2Agent : public Xabsl2NamedItem
{
public:
  /**
  * Constructor
  * @param name The name of the agent
  * @param rootOption A pointer to the initial option of the agent
  * @param errorHandler Is invoked when errors occur
  */
  Xabsl2Agent(const char* name, Xabsl2Option* rootOption,
    Xabsl2ErrorHandler& errorHandler);

  /** Returns the root option */
  Xabsl2Option* getRootOption() const;
private:

  /** A pointer to the root option */
  Xabsl2Option* rootOption;

  /** Is invoked when errors occur */
  Xabsl2ErrorHandler& errorHandler;
};

#endif // __Xabsl2Agent_h_

/*
* Change Log:
*
* $Log: Xabsl2Agent.h,v $
* Revision 1.1  2003/10/07 10:13:25  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/30 10:51:10  dueffert
* typos fixed
*
* Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/01/11 14:41:42  loetzsch
* continued creation of the option tree
*
* Revision 1.1  2003/01/09 17:28:33  loetzsch
* introduced Xabsl2Agent, continued Xabsl2Option
*
*/
