/**
* @file StringFunctions.cpp
*
* Implementation of common string functions
*
* @author Uwe Dffert
*/

#include "StringFunctions.h"
#include <string.h>

void getXmlString(char* dstXml, const char* src)
{
/** @todo Header/Xabsl interpretation differences:
* tail-mode.TAIL-center/left/right-*
* top.left/right-ONLY
* *-paw-kick-forward vs. paw-kick-with-*-forward
* start-me-UP
* HEAD-CONTROL-MODE.*
  */
  unsigned int i=0;
  unsigned int j=0;
  char lastChar='A';
  int charsSinceLastMinus=0;
  while (i<strlen(src))
  {
    if (((lastChar<'A')||(lastChar>'Z'))&&(src[i]>='A')&&(src[i]<='Z'))
    {
      lastChar=src[i]|0x20; 
      if (charsSinceLastMinus > 1)
      {
        dstXml[j++]='-';
        charsSinceLastMinus=0;
      }
      dstXml[j++]=src[i++]|0x20;
      dstXml[j]=0;
      charsSinceLastMinus++;
    }
    else
    {
      lastChar=src[i];
      dstXml[j++]=src[i++];
      dstXml[j]=0;
      charsSinceLastMinus++;
    }
  }
}

/*
* Change log :
* 
* $Log: StringFunctions.cpp,v $
* Revision 1.2  2004/02/25 15:28:03  jhoffman
* kick renamed
*
* Revision 1.1  2003/10/07 10:13:21  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/05/11 23:56:15  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2003/05/06 16:02:54  loetzsch
* added class RobotPoseSymbols
*
*/
