/**
 * @file SlidingAverageValue.cpp
 *
 * Implementation of class SlidingAverageValue
 *
 * @author Jochen Kerdels
 */

#include "SlidingAverageValue.h"


SlidingAverageValue::SlidingAverageValue()
{
  reset(maxSlidingRange);
}

void SlidingAverageValue::reset(int aSize)
{
  size = aSize;
  if (size > maxSlidingRange)
    size = maxSlidingRange;
  if (size < 1)
    size = 1;

  minIdx        = 0;
  maxIdx        = -1;
  numOfEntries  = 0;
  timeOfLastAdd = -1;
  sum           = 0;
  trig          = 0;
}

void SlidingAverageValue::trigger ()
{
  ++trig%=100000;
}

void SlidingAverageValue::add (int value) 
{
  if (timeOfLastAdd == trig) {
    sum -= buffer[maxIdx];
  } else {
    timeOfLastAdd = trig;
    ++maxIdx %= size;
    if ((maxIdx == minIdx) && (numOfEntries > 0)){
      sum -= buffer[minIdx];
      ++minIdx %= size;
    }
    else
      numOfEntries++;
  }
  buffer[maxIdx] = value;
  sum += buffer[maxIdx];
}

int SlidingAverageValue::getAverage()
{
  if (numOfEntries > 0)
    return (sum / numOfEntries);
  else
    return 0;
}

int SlidingAverageValue::getLastValue()
{
  if (numOfEntries > 0)
    return buffer[maxIdx];
  else
    return 0;
}


SlidingAverageValue& SlidingAverageValue::operator=(int aInt)
{
  add(aInt);
  return *this;
}

SlidingAverageValue& SlidingAverageValue::operator-=(int aInt)
{
  add(buffer[maxIdx]-aInt);
  return *this;
}

SlidingAverageValue& SlidingAverageValue::operator+=(int aInt)
{
  add(buffer[maxIdx]+aInt);
  return *this;
}



/*
 * Change log :
 * 
 * $Log: SlidingAverageValue.cpp,v $
 * Revision 1.1  2004/04/08 16:04:06  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.1  2004/03/21 04:36:07  pg_joke
 * added slidingAverage to OptionRatings,
 * added ratingBoost (Hysteresis) to OptionRatings
 *
 *
 */
