/**
* @file ModuleHandler.h
*
* Declaration of class ModuleHandler
*
* @author Max Risler
* @author Martin Ltzsch
*/

#ifndef __ModuleHandler_h_
#define __ModuleHandler_h_

#include "ModuleSelector.h"

/**
* @class ModuleHandler
* 
* Manages runtime exhangeable modules.
* 
* @author Max Risler
* @author Martin Ltzsch
*/
class ModuleHandler : public MessageHandler
{
private: 
  /** Pointers to all module selectors */
  ModuleSelector *pModuleSelectors[SolutionRequest::numOfModules];

public:
  /** Constructor */
  ModuleHandler();
  
  /**
  * Returns pointer to selector module.
  * @param id id of module.
  */
  ModuleSelector *pGetModuleSelector(SolutionRequest::ModuleID id) const;
  
  /**
  * Set pointer to selector module.
  * @param id id of module.
  * @param module a pointer to the module selector
  */
  void setModuleSelector(SolutionRequest::ModuleID id, 
    ModuleSelector* module);
  
  /** Returns the id of the selected solution for a module id */
  SolutionRequest::ModuleSolutionID getSelectedSolution(SolutionRequest::ModuleID id) const;
  
  /** Selects solution defined by solution in module id */
  void selectSolution(SolutionRequest::ModuleID id, SolutionRequest::ModuleSolutionID solution);
  
  /** Selects solutions as defined by a solution request */
  void selectSolutions(SolutionRequest request);
  
  /** 
  * Called from a MessageQueue to distribute messages.
  * Use message.getMessageID to decide if the message is relavant for 
  * the MesssageHandler derivate.
  * Use message.bin, message.text or message.config as In streams to get the data from.
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
};


#endif //__ModuleHandler_h_

/*
* Change log :
* 
* $Log: ModuleHandler.h,v $
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/07 10:13:24  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2002/09/25 10:25:13  loetzsch
* removed the "executeVisionModules" variable
* from SolutionRequest and ModuleHandler.
*
* Revision 1.3  2002/09/10 21:07:30  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.2  2002/09/10 17:53:26  loetzsch
* First draft of new Module/Solution Architecture
*
* Revision 1.1  2002/09/10 15:53:59  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/06/04 00:12:45  loetzsch
* added bool executeVisionModules
*
* Revision 1.1.1.1  2002/05/10 12:40:32  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.9  2002/02/08 18:36:03  risler
* removed destructor again
*
* Revision 1.8  2002/02/08 17:48:21  risler
* destructor added
*
* Revision 1.7  2002/01/20 13:00:18  risler
* changed implementation of selecting default solution
*
* Revision 1.6  2002/01/19 12:43:16  risler
* enabled SolutionRequest, changed HandleDebugMessage calls
*
* Revision 1.5  2002/01/17 14:35:48  risler
* SolutionRequest added
*
* Revision 1.4  2001/12/10 17:47:10  risler
* change log added
*
*/
