/**
* @file LogPlayerWithSync.h
*
* Extension of class LogPlayer
*
* @author Jrn Hamerla
*/

#ifndef __LogPlayerWithSync_h_
#define __LogPlayerWithSync_h_

#include "LogPlayer.h"

/**
* @class LogPlayerWithSync
*
* Extension to Sync more Logfiles
* gametime Time started with Game
*
* @author Jrn Hamerla
*/
class LogPlayerWithSync : public LogPlayer
{
public:
  /** 
  * Constructor 
  * @param targetQueue The queue into that messages from played logfiles shall be stored.
  * @param playtime pointer to a timer
  */
  LogPlayerWithSync(MessageQueue& targetQueue, long* playtime = 0);

  /** 
  * plays one Message if it is time
  */
  void onIdle();

  /**
  * seek to position of Timestamp
  * @param time 
  * @return false if time is befor first messag or after last message
  */
  bool seek(unsigned long time);

  /**
  * seek to position of Playtime
  * @param time 
  * @return false if time is befor first messag or after last message
  */
  bool seek(long time);

  /**
  * get the position of the Logfile as Gametime
  * @return position of Logfile (Gametime)
  */
  long getGameTime();

  /**
  * get the time of the Logfile 
  * @return position of Logfile 
  */
  unsigned long getTime();

  /**
  * set the sync time
  * @param time of an selected Event
  */
  void setSync(unsigned long time);

  /**
  * Synchrons the Logfile relative to the GamestartTime
  * @param startTime time the game started
  */
//  void syncToStartTime(unsigned long starttime);

  /**
  * @return SyncTime
  */
  unsigned long getSyncTime();

  /**
  * get the time the game started
  * @return gamestarttime
  */
  unsigned long getGamestartTime();

  /**
  * get the Time the Logfile started
  * @return logstarttime
  */
  unsigned long getLogstartTime();

  /**
  * get the Time the Logfile ends
  * @return logendtime
  */
  unsigned long getLogendTime();

  /**
  * returns the next Time a Message should send
  * @return Next MessageTime as PlayTime
  */
  long getNextStepForward();

  /**
  * returns the Time the last Message was send
  * @return Last MessageTime as PlayTime
  * @see getNextStepForward
  */
  long getNextStepBackward();

  /**
  * ...
  */
  MessageID getMessageID(int message);

  /**
  * ...
  */
  void setSelectedMessageForReading(int message);

  /**
  * ...
  */
  InMessage getMessage();

  /**
  * ...
  */
  void setPlayerForNewMessages(const Player&player);

  /**
  * @return true if the player is to slow
  */
  bool hasTimeDelay();


protected:

  /**
  * Returns the time stamp of a given message.
  * @param message The number of the message 
  * @return The time stamp
  */
  unsigned long getTimeStamp(int message);

  /**
  * point of one event
  */
  unsigned long m_syncTime;

  /**
  * playtime 
  * time relative to the syncevent
  */
  long*	m_playTime;

private:
	unsigned int m_counterSend;


};


#endif //__LogPlayer_h_

/*
*
*/
