/**
* @file Location.cpp
*
* Implementation of class Location.
* 
* @author Max Risler
*/

#include "Location.h"
#include "Tools/Streams/InStreams.h"

static Location theLocation;

Location& getLocation()
{
  return theLocation;
}

Location::Location()
{
  name[0] = 0;
  InConfigFile file("location.cfg");
  if(file.exists() && !file.eof())
  {
    file >> name;
  }
}

const char* Location::getFilename(const char *file)
{
  if (name[0] == 0)
    return file;

  sprintf(filename, "%s/%s", name, file);
  return filename;
}

/*
 * Change log :
 * 
 * $Log: Location.cpp,v $
 * Revision 1.1  2003/10/07 10:13:21  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/30 16:26:06  risler
 * bugfix: name initialization
 *
 * Revision 1.1  2003/05/11 17:03:00  risler
 * added location.cfg
 *
 */
