/**
* @file Parcour.h
*
* Declaration of class Parcour, ForwardTurningParcour, SimpleBackwardParcour
*
* @author <a href=mailto:dueffert@informatik.hu-berlin.de>Uwe Dffert</a>
*/

#ifndef __Parcour_h_
#define __Parcour_h_

#include "Tools/Math/Pose2D.h"
#include "Tools/Math/Vector3.h"

/**
* @class Parcour
*
* Contains a walking parcour with all relevant data to calculate next useful MotionRequest, resulting fitness, ...
*/
class Parcour
{
public:
  /** Constructor. */
  Parcour():updateCount(0),startTime(0),lastTime(0),lastRobotPose(0,0,0),minX(-1000),maxX(-1000),yDiffIntegral(0),arcDiffIntegral(0),blindCount(0),zAccelIntegral(0) {}
  
  /** Destructor. */
  ~Parcour() {}

  /** start walking on the parcour: set start time, reset fitness stuff */
  void start();

  /** update the state of the parcour with all current data */
  void update(Pose2D robotPose, Vector3<double> accel, bool blind);

  /** return a MotionRequest that is useful at the moment to follow the parcour */
  Pose2D getMotionRequest();

  /** return something like speed in mm/s considering a useful portion of the integral errors */
  double getUnifiedSpeed();

  unsigned long updateCount;

//protected:
  virtual Pose2D getTargetPose(unsigned long targetTime) = 0;

  unsigned long startTime;
  unsigned long lastTime;
  Pose2D lastRobotPose;
  double minX,maxX;
  double yDiffIntegral;
  double arcDiffIntegral;
  int blindCount;
  double zAccelIntegral;
};

/**
* @class ForwardTurningParcour
*
* Contains a special walking parcour
*/
class ForwardTurningParcour : public Parcour
{
public:
  virtual Pose2D getTargetPose(unsigned long targetTime);
};

/**
* @class SimpleBackwardParcour
*
* Contains a special walking parcour
*/
class SimpleBackwardParcour : public Parcour
{
public:
  virtual Pose2D getTargetPose(unsigned long targetTime);
};

#endif //__Parcour_h_

/*
* Change log :
*
* $Log: Parcour.h,v $
* Revision 1.4  2004/02/10 11:11:20  dueffert
* Parcour improved
*
* Revision 1.3  2004/01/28 08:28:48  dueffert
* Parcour improved
*
* Revision 1.2  2003/11/18 15:46:54  dueffert
* some improvements
*
* Revision 1.1  2003/11/17 17:19:48  dueffert
* new class
*
*
*/
