/**
* @file Individual.cpp
*
* Implementation of class Individual.
*
* @author <a href=mailto:dueffert@informatik.hu-berlin.de>Uwe Dffert</a>
* @author <a href="mailto:a.cesarz@gmx.de">Arthur Cesarz</a>
* @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
*/

#include "Individual.h"
#include "Tools/Math/Common.h"

Individual::Individual():fitness(-1)
{
}

void Individual::mutationOf(Individual* father, double rate, double amount, bool uniformNoise/*, other EvoParams*/)
{
/*
FlipMutate: flip bits: not usefull here
SwapMutate: swap two numbers: only usefull with data of same type
*/
  int max1,max2;
  getDimension(max1,max2);
  for (int i=0;i<max1;i++)
  {
    bool doMutate=((double)rand()/(RAND_MAX+1.0)<rate);
    for (int j=0;j<max2;j++)
    {
      double min,max,val;
      ValueType type;
      father->getValue(i,j,min,max,val,type);
      if (doMutate)
      {
        switch(type)
        {
          case valueInt:
            //2do: Sprung zum naechsten mit Wahrscheinlichkeit schaffen
          case valueDouble:
          case value2PiDouble:
            if (uniformNoise)
            {
              // add uniform distributed value
              val += (random()-0.5)*amount*(max-min);
            }
            else
            {
              // add gauss distributed value
              val += amount*(max-min)*sqrt(-2.0*log(random()))*sin(pi2*random());
            }
        }
        if (type==value2PiDouble)
        {
          val = (val<-pi)?val+pi2:((val>=pi)?val-pi2:val);
        }
        val = (val<min)?min:((val>max)?max:val);
      }
      setValue(i,j,val);
    }
  }
  fitness=-1;
}

void Individual::crossingOverOf(Individual* father, Individual* mother/*, other EvoParams*/)
{
/*UniformCrossover: For each bit we flip a coin to see if that bit should come from the mother or the father.
EvenOddCrossover:
OnePointCrossover:
TwoPointCrossover:
*/

  int max1,max2;
  getDimension(max1,max2);

  //find random value around better parent or mixture of parents
  double fitDiff=father->fitness-mother->fitness;
  if (fitDiff<-10) {fitDiff=-10;}
  else if (fitDiff>10) {fitDiff=10;}
  double fatherFactor=(10+fitDiff)/20;
  for (int i=0;i<max1;i++)
  {
    //Roefer-like Crossover (with intra- and extrapolation)
    for (int j=0;j<max2;j++)
    {
      double minVal,maxVal,valF,valM;
      ValueType type;
      father->getValue(i,j,minVal,maxVal,valF,type);
      mother->getValue(i,j,minVal,maxVal,valM,type);
      double valMiddle=fatherFactor*valF+(1-fatherFactor)*valM;
      double val=valMiddle+(random()-0.5)*2*fabs(valF-valM);
      val=(val<minVal)?minVal:((val>maxVal)?maxVal:val);
      setValue(i,j,val);
    }
    /*
    //EvenOddCrossover
    bool fromFather=((i%2)==0);
    for (int j=0;j<max2;j++)
    {
    double min,max,val;
    ValueType type;
    if (fromFather)
    {
    father->getValue(i,j,min,max,val,type);
    }
    else
    {
    mother->getValue(i,j,min,max,val,type);
    }
    setValue(i,j,val);
    }
    */
  }
  fitness=-1;
}

/*
* Change log :
* 
* $Log: Individual.cpp,v $
* Revision 1.6  2004/05/24 13:06:01  dueffert
* extrapolation added
*
* Revision 1.5  2004/03/24 13:47:10  dueffert
* own new bug fixed
*
* Revision 1.4  2004/03/24 13:44:49  dueffert
* support for uniform noise mutation readded
*
* Revision 1.3  2004/02/28 11:49:10  cesarz
* changed uniformly distributed random value to gauss distributed value
*
* Revision 1.2  2004/02/26 18:07:28  cesarz
* first version of evolution behavior
*
* Revision 1.1  2003/10/07 10:13:22  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1  2003/09/26 11:40:40  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.3  2003/09/01 15:57:42  dueffert
* Genom and Individual merged
*
* Revision 1.2  2003/08/08 14:27:07  dueffert
* implementation added
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/02/10 15:26:58  dueffert
* self made GA stuff
*
*
*/
