#include "RateableOptions.h"

#ifndef OPENCHALLENGE_DEFINES

RateableOptions::OptionInfo  RateableOptions::optionInfos[] = {
  // options
  //
  { noOption,                      "NoOption",                       0, 0, notype       ,1  ,0 }, 
  { doNothing,                     "DoNothing",                      0, 0, special      ,1  ,0 },
  { stand,                         "Stand",                          0, 0, gotoPos      ,1  ,0 },
  { keepOption,                    "KeepOption",                     0, 0, notype       ,1  ,0 },
  { goToFrontLeft,                 "GoToFrontLeft",                  0, 0, gotoPos      ,5  ,0 },
  { goToFrontPenLeft,              "GoToFrontPenLeft",               0, 0, gotoPos      ,5  ,0 },
  { goToFrontMiddle,               "GoToFrontMiddle",                0, 0, gotoPos      ,5  ,0 },
  { goToFrontPenRight,             "GoToFrontPenRight",              0, 0, gotoPos      ,5  ,0 },
  { goToFrontRight,                "GoToFrontRight",                 0, 0, gotoPos      ,5  ,0 },
  { goToMiddleLeft,                "GoToMiddleLeft",                 0, 0, gotoPos      ,5  ,0 },
  { goToMiddle,                    "GoToMiddle",                     0, 0, gotoPos      ,5  ,0 },
  { goToMiddleRight,               "GoToMiddleRight",                0, 0, gotoPos      ,5  ,0 },
  { goToBehindLeft,                "GoToBehindLeft",                 0, 0, gotoPos      ,5  ,0 },
  { goToBehindMiddle,              "GoToBehindMiddle",               0, 0, gotoPos      ,5  ,0 },
  { goToBehindRight,               "GoToBehindRight",                0, 0, gotoPos      ,5  ,0 },
  { goToCatenaccioLeft,            "GoToCatenaccioLeft",             0, 0, gotoPos      ,5  ,0 },
  { goToCatenaccioMiddle,          "GoToCatenaccioMiddle",           0, 0, gotoPos      ,5  ,0 },
  { goToCatenaccioRight,           "GoToCatenaccioRight",            0, 0, gotoPos      ,5  ,0 },
  { approachCloseBall,             "ApproachCloseBall",              0, 0, gotoBallPos  ,5  ,10 },
  { goToBall,                      "GoToBall",                       0, 0, gotoBallPos  ,5  ,10 },
  { goToBallFrontLeft,             "GoToBallFrontLeft",              0, 0, gotoBallPos  ,5  ,10 },
  { goToBallFrontMiddle,           "GoToBallFrontMiddle",            0, 0, gotoBallPos  ,5  ,10 },
  { goToBallFrontRight,            "GoToBallFrontRight",             0, 0, gotoBallPos  ,5  ,10 },
  { goToBallMiddleLeft,            "GoToBallMiddleLeft",             0, 0, gotoBallPos  ,5  ,10 },
  { goToBallMiddle,                "GoToBallMiddle",                 0, 0, gotoBallPos  ,5  ,10 },
  { goToBallMiddleRight,           "GoToBallMiddleRight",            0, 0, gotoBallPos  ,5  ,10 },
  { goToBallBehindLeft,            "GoToBallBehindLeft",             0, 0, gotoBallPos  ,5  ,10 },
  { goToBallBehindMiddle,          "GoToBallBehindMiddle",           0, 0, gotoBallPos  ,5  ,10 },
  { goToBallBehindRight,           "GoToBallBehindRight",            0, 0, gotoBallPos  ,5  ,10 },
  { goToBallGoalie,                "GoToBallGoalie",                 0, 0, gotoBallPos  ,5  ,10 },
  { goIntoOwnGoal,                 "GoIntoOwnGoal",                  0, 0, gotoPos      ,5  ,0 },
  { doJumpDefend,                  "DoJumpDefend",                   0, 0, special      ,1  ,0 },
  { doJumpLeft,                    "DoJumpLeft",                     0, 0, special      ,1  ,0 },
  { doJumpRight,                   "DoJumpRight",                    0, 0, special      ,1  ,0 },
  { kickToGoal,                    "KickToGoal",                     0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromFrontLeft,       "KickToGoalFromFrontLeft",        0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromFrontMiddle,     "KickToGoalFromFrontMiddle",      0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromFrontRight,      "KickToGoalFromFrontRight",       0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromMiddleLeft,      "KickToGoalFromMiddleLeft",       0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromMiddle,          "KickToGoalFromMiddle",           0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromMiddleRight,     "KickToGoalFromMiddleRight",      0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromBehindLeft,      "KickToGoalFromBehindLeft",       0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromBehindMiddle,    "KickToGoalFromBehindMiddle",     0, 0, kickAction   ,5  ,10 },
  { kickToGoalFromBehindRight,     "KickToGoalFromBehindRight",      0, 0, kickAction   ,5  ,10 },
  { kickToTeammate1,               "KickToTeammate1",                0, 0, kickAction   ,5  ,10 },
  { kickToTeammate2,               "KickToTeammate2",                0, 0, kickAction   ,5  ,10 },
  { kickToTeammate3,               "KickToTeammate3",                0, 0, kickAction   ,5  ,10 },
  { kickToClear,                   "KickToClear",                    0, 0, kickAction   ,5  ,10 },
  { kickToClearFromFrontLeft,      "KickToClearFromFrontLeft",       0, 0, kickAction   ,5  ,10 },
  { kickToClearFromFrontMiddle,    "KickToClearFromFrontMiddle",     0, 0, kickAction   ,5  ,10 },
  { kickToClearFromFrontRight,     "KickToClearFromFrontRight",      0, 0, kickAction   ,5  ,10 },
  { kickToClearFromMiddleLeft,     "KickToClearFromMiddleLeft",      0, 0, kickAction   ,5  ,10 },
  { kickToClearFromMiddle,         "KickToClearFromMiddle",          0, 0, kickAction   ,5  ,10 },
  { kickToClearFromMiddleRight,    "KickToClearFromMiddleRight",     0, 0, kickAction   ,5  ,10 },
  { kickToClearFromBehindLeft,     "KickToClearFromBehindLeft",      0, 0, kickAction   ,5  ,10 },
  { kickToClearFromBehindMiddle,   "KickToClearFromBehindMiddle",    0, 0, kickAction   ,5  ,10 },
  { kickToClearFromBehindRight,    "KickToClearFromBehindRight",     0, 0, kickAction   ,5  ,10 },
  { kickToClearGoalie,             "KickToClearGoalie",              0, 0, kickAction   ,5  ,10 },
  { intercept1,                    "Intercept1",                     0, 0, gotoPos      ,5  ,0 },
  { intercept2,                    "Intercept2",                     0, 0, gotoPos      ,5  ,0 },
  { intercept3,                    "Intercept3",                     0, 0, gotoPos      ,5  ,0 },
  { intercept4,                    "Intercept4",                     0, 0, gotoPos      ,5  ,0 },
  { handleBallLeftBorder,          "HandleBallLeftBorder",           0, 0, special      ,1  ,0 },
  { handleBallRightBorder,         "HandleBallRightBorder",          0, 0, special      ,1  ,0 },
  { dribbleToFront,                "DribbleToFront",                 0, 0, special      ,1  ,0 },
  { goToInterceptBall,             "GoToInterceptBall",              0, 0, gotoPos      ,5  ,0 },
  { bananaCrossFromLeft,           "BananaCrossFromLeft",            0, 0, special      ,1  ,0 },
  { bananaCrossFromRight,          "BananaCrossFromRight",           0, 0, special      ,1  ,0 },
  { doRollLeft,                    "DoRollLeft",                     0, 0, special      ,1  ,0 },
  { doRollRight,                   "DoRollRight",                    0, 0, special      ,1  ,0 },
  { turnForBall,                   "TurnForBall",                    0, 0, special      ,1  ,0 },
  { goToGoaliePos,                 "GoToGoaliePos",                  0, 0, gotoPos      ,5  ,0 },

  { backUp,                        "BackUp",                         0, 0, special      ,5  ,0 },

  { waveLeft,                      "WaveLeft",                       0, 0, goalieAction ,1  ,0 },
  { waveRight,                     "WaveRight",                      0, 0, goalieAction ,1  ,0 },

  { newKickToGoal,                 "NewKickToGoal",                  0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromFrontLeft,    "NewKickToGoalFromFrontLeft",     0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromFrontMiddle,  "NewKickToGoalFromFrontMiddle",   0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromFrontRight,   "NewKickToGoalFromFrontRight",    0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromMiddleLeft,   "NewKickToGoalFromMiddleLeft",    0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromMiddle,       "NewKickToGoalFromMiddle",        0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromMiddleRight,  "NewKickToGoalFromMiddleRight",   0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromBehindLeft,   "NewKickToGoalFromBehindLeft",    0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromBehindMiddle, "NewKickToGoalFromBehindMiddle",  0, 0, kickAction   ,5  ,10 },
  { newKickToGoalFromBehindRight,  "NewKickToGoalFromBehindRight",   0, 0, kickAction   ,5  ,10 },
  { newKickToTeammate1,            "NewKickToTeammate1",             0, 0, kickAction   ,5  ,10 },
  { newKickToTeammate2,            "NewKickToTeammate2",             0, 0, kickAction   ,5  ,10 },
  { newKickToTeammate3,            "NewKickToTeammate3",             0, 0, kickAction   ,5  ,10 },
  { newKickToClear,                "NewKickToClear",                 0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromFrontLeft,   "NewKickToClearFromFrontLeft",    0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromFrontMiddle, "NewKickToClearFromFrontMiddle",  0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromFrontRight,  "NewKickToClearFromFrontRight",   0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromMiddleLeft,  "NewKickToClearFromMiddleLeft",   0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromMiddle,      "NewKickToClearFromMiddle",       0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromMiddleRight, "NewKickToClearFromMiddleRight",  0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromBehindLeft,  "NewKickToClearFromBehindLeft",   0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromBehindMiddle,"NewKickToClearFromBehindMiddle", 0, 0, kickAction   ,5  ,10 },
  { newKickToClearFromBehindRight, "NewKickToClearFromBehindRight",  0, 0, kickAction   ,5  ,10 },
  { newKickToClearGoalie,          "NewKickToClearGoalie",           0, 0, kickAction   ,5  ,10 },

  { goToFrontAtBall,               "GoToFrontAtBall",                0, 0, gotoPos      ,3 ,0 },
  { goToMiddleAtBall,              "GoToMiddleAtBall",               0, 0, gotoPos      ,3 ,0 },
  { goToBehindAtBall,              "GoToBehindAtBall",               0, 0, gotoPos      ,3 ,0 },
  { goToRightAtBall,               "GoToRightAtBall",                0, 0, gotoPos      ,3 ,0 },
  { goToLeftAtBall,                "GoToLeftAtBall",                 0, 0, gotoPos      ,3 ,0 },
  // option classes
  //
  { goToAnyFront,           "GoToAnyFront",          3, 10, notype ,0  ,0 },  
  { goToAnyMiddle,          "GoToAnyMiddle",         3, 10, notype ,0  ,0 },
  { goToAnyBehind,          "GoToAnyBehind",         3, 10, notype ,0  ,0 },
  { kickToTeammate,         "KickToTeammate",        3, 10, notype ,0  ,0 },
  { intercept,              "Intercept",             4, 10, notype ,0  ,0 },
  { goToAnyLeft,            "GoToAnyLeft",           3, 10, notype ,0  ,0 },
  { goToAnyRight,           "GoToAnyRight",          3, 10, notype ,0  ,0 },
  { goToBallAnyLeft,        "GoToBallAnyLeft",       3, 10, notype ,0  ,0 },
  { goToBallAnyRight,       "GoToBallAnyRight",      3, 10, notype ,0  ,0 },
  { newKickToTeammate,      "NewKickToTeammate",     3, 10, notype ,0  ,0 },
  
  // end marker
  //
  { -1, NULL, 0, 0, notype ,0  ,0 }
};
#else
RateableOptions::OptionInfo  RateableOptions::optionInfos[] = {
  // options
  //
  { noOption,                      "NoOption",                       0, 0, notype       ,1  ,0 }, 
  { doNothing,                     "DoNothing",                      0, 0, special      ,1  ,0 },
  { stand,                         "Stand",                          0, 0, gotoPos      ,1  ,0 },
  { keepOption,                    "KeepOption",                     0, 0, notype       ,1  ,0 },
  { intro,                         "Intro",                          0, 0, notype       ,1  ,0 },  
  { extro,                         "Extro",                          0, 0, notype       ,1  ,0 },  
  { finished,                      "Finished",                       0, 0, notype       ,1  ,0 },  
  { gotoBitePos1,                  "GotoBitePos1",                   0, 0, notype       ,1  ,0 },  
  { gotoBitePos2,                  "GotoBitePos2",                   0, 0, notype       ,1  ,0 },  
  { gotoBitePos3,                  "GotoBitePos3",                   0, 0, notype       ,1  ,0 },  
  { gotoBitePos4,                  "GotoBitePos4",                   0, 0, notype       ,1  ,0 },  
  { bitePos1,                      "BitePos1",                       0, 0, notype       ,1  ,0 },  
  { bitePos2,                      "BitePos2",                       0, 0, notype       ,1  ,0 },  
  { bitePos3,                      "BitePos3",                       0, 0, notype       ,1  ,0 },  
  { bitePos4,                      "BitePos4",                       0, 0, notype       ,1  ,0 },  
  { movePos1,                      "MovePos1",                       0, 0, notype       ,1  ,0 },  
  { movePos2,                      "MovePos2",                       0, 0, notype       ,1  ,0 },  
  { movePos3,                      "MovePos3",                       0, 0, notype       ,1  ,0 },  
  { movePos4,                      "MovePos4",                       0, 0, notype       ,1  ,0 },  
  { gotoBridge,                    "GotoBridge",                     0, 0, notype       ,1  ,0 },  
  { climbBridge,                   "ClimbBridge",                    0, 0, notype       ,1  ,0 },  
  { moveBridge,                    "MoveBridge",                     0, 0, notype       ,1  ,0 },  
  { waitForBiteDogs,               "waitForBiteDogs",                0, 0, notype       ,1  ,0 },  

  // we need at least one option class
  { doSomething,           "DoSomething",          1, 10, notype ,0  ,0 },  
  // end marker
  //
  { -1, NULL, 0, 0, notype ,0  ,0 }
};
#endif


int RateableOptions::getNumberOfClassMembers(OptionClassID id)
{
  for (OptionInfo *o=optionInfos; o->id != -1; o++) {
    if (o->id == id)
      return o->numOfSubOptions;
  }  
  return 0;
}

int RateableOptions::getOptionClassChangeThreshold(OptionClassID id)
{
  for (OptionInfo *o=optionInfos; o->id != -1; o++) {
    if (o->id == id)
      return o->changeThreshold;
  }  
  return 0;
}

RateableOptions::OptionID RateableOptions::getClassMember(OptionClassID id, int idx)
{
#ifndef OPENCHALLENGE_DEFINES

  switch (id) {
    case goToAnyFront:
      switch (idx) {
        case 0   : return goToFrontLeft;
        case 1   : return goToFrontMiddle;
        case 2   : return goToFrontRight;
      }
      break;

    case goToAnyMiddle:
      switch (idx) {
        case 0   : return goToMiddleLeft;
        case 1   : return goToMiddle;
        case 2   : return goToMiddleRight;
      }
      break;

    case goToAnyBehind:
      switch (idx) {
        case 0   : return goToBehindLeft;
        case 1   : return goToBehindMiddle;
        case 2   : return goToBehindRight;
      }
      break;

    case kickToTeammate:
      switch (idx) {
        case 0   : return kickToTeammate1;
        case 1   : return kickToTeammate2;
        case 2   : return kickToTeammate3;
      }
      break;

    case intercept:
      switch (idx) {
        case 0   : return intercept1;
        case 1   : return intercept2;
        case 2   : return intercept3;
        case 3   : return intercept4;
      }
      break;


    case goToAnyLeft:
      switch (idx) {
        case 0   : return goToFrontLeft;
        case 1   : return goToMiddleLeft;
        case 2   : return goToBehindLeft;
      }
      break;

    case goToAnyRight:
      switch (idx) {
        case 0   : return goToFrontRight;
        case 1   : return goToMiddleRight;
        case 2   : return goToBehindRight;
      }
      break;

    case goToBallAnyLeft:
      switch (idx) {
        case 0   : return goToBallFrontLeft;
        case 1   : return goToBallMiddleLeft;
        case 2   : return goToBallBehindLeft;
      }
      break;

    case goToBallAnyRight:
      switch (idx) {
        case 0   : return goToBallFrontRight;
        case 1   : return goToBallMiddleRight;
        case 2   : return goToBallBehindRight;
      }
      break;

    case newKickToTeammate:
      switch (idx) {
        case 0   : return newKickToTeammate1;
        case 1   : return newKickToTeammate2;
        case 2   : return newKickToTeammate3;
      }
      break;

  }
#else 
  switch (id) {
    case doSomething:
      switch (idx) {
        case 0   : return stand;
      }
      break;
  }

#endif
  return noOption;
}


/**
 * returns names for option and option class ids
 */
const char* RateableOptions::getOptionName(int id)
{
  for (OptionInfo *o=optionInfos; o->id != -1; o++) {
    if (o->id == id)
      return o->name;
  }
  return "please edit the RateableOptions::optionInfos array";
}


/**
 * returns ids for option and option class names
 */
int RateableOptions::getOptionID(const char* name)
{
  for (OptionInfo *o=optionInfos; o->id != -1; o++) {
    if (!strcmp(name, o->name))
      return o->id;
  }
  return -1;
};

/**
 * returns types for option ids
 */
RateableOptions::OptionType RateableOptions::getOptionType(int id)
{
  for (OptionInfo *o=optionInfos; o->id != -1; o++) {
    if (o->id == id)
      return o->optionType;
  }
  return notype;
};

/**
 * returns SlidingAverageRange for option and option class names
 */
int RateableOptions::getSlidingAverageRange(int id)
{
  for (OptionInfo *o=optionInfos; o->id != -1; o++) {
    if (o->id == id)
      return o->slidingAverageRange;
  }
  return -1;
};

/**
 * returns RatingBoost for option and option class names
 */
int RateableOptions::getRatingBoost(int id)
{
  for (OptionInfo *o=optionInfos; o->id != -1; o++) {
    if (o->id == id)
      return o->ratingBoost;
  }
  return -1;
};


/**
 * returns true, if id is an option class, else false
 */
bool RateableOptions::isOptionClass(int id)
{
  return getNumberOfClassMembers( (OptionClassID)id ) != noOption;
}


/**
 * returns true, if Oid is a member of the option class OCid, else false
 */
bool RateableOptions::isClassMember(OptionClassID OCid, OptionID Oid)
{
#ifndef OPENCHALLENGE_DEFINES

  switch (OCid) {
    case goToAnyFront:
      switch (Oid) {
        case goToFrontLeft:
        case goToFrontMiddle:
        case goToFrontRight: return true;
      }
      break;

    case goToAnyMiddle:
      switch (Oid) {
        case goToMiddleLeft:
        case goToMiddle:
        case goToMiddleRight: return true;
      }
      break;

    case goToAnyBehind:
      switch (Oid) {
        case goToBehindLeft:
        case goToBehindMiddle:
        case goToBehindRight: return true;
      }
      break;

    case kickToTeammate:
      switch (Oid) {
        case kickToTeammate1:
        case kickToTeammate2:
        case kickToTeammate3: return true;
      }
      break;

    case intercept:
      switch (Oid) {
        case intercept1:
        case intercept2:
        case intercept3:
        case intercept4: return true;
      }
      break;


    case goToAnyLeft:
      switch (Oid) {
        case goToFrontLeft:
        case goToMiddleLeft:
        case goToBehindLeft: return true;
      }
      break;

    case goToAnyRight:
      switch (Oid) {
        case goToFrontRight:
        case goToMiddleRight:
        case goToBehindRight: return true;
      }
      break;

    case goToBallAnyLeft:
      switch (Oid) {
        case goToBallFrontLeft:
        case goToBallMiddleLeft:
        case goToBallBehindLeft: return true;
      }
      break;

    case goToBallAnyRight:
      switch (Oid) {
        case goToBallFrontRight:
        case goToBallMiddleRight:
        case goToBallBehindRight: return true;
      }
      break;

    case newKickToTeammate:
      switch (Oid) {
        case newKickToTeammate1:
        case newKickToTeammate2:
        case newKickToTeammate3: return true;
      }
      break;

  }
#else
  switch (OCid) {
    case doSomething:
      switch (Oid) {
        case stand: return true;
      }
      break;
   
  }

#endif
  return false;
}


/*
 * Change log :
 * $Log: RateableOptions.cpp,v $
 * Revision 1.34  2004/06/21 11:55:04  hamerla
 * OpenChallenge
 *
 * Revision 1.33  2004/06/07 22:43:27  kerdels
 * added a dtt-switch for open-challenge,
 * merged a bugfix for optionratingdlgbar from local-cvs to tamara,
 * created tactic-entries for openchallenge
 *
 * Revision 1.32  2004/06/07 16:00:57  hamerla
 * OptionRation fr OpenChallenge
 *
 * Revision 1.31  2004/05/12 19:33:14  kerdels
 * merged the behavior changes during australian, american and japan open
 *
 * Revision 1.30  2004/04/08 17:14:27  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.36  2004/04/03 00:53:46  huelsbusch
 * changed ball-rating
 *
 * Revision 1.35  2004/04/01 14:18:45  kerdels
 * retuned jump-defend
 *
 * Revision 1.34  2004/03/29 12:56:05  pg_clri
 * *** empty log message ***
 *
 * Revision 1.33  2004/03/24 15:32:11  pg_joke
 * added a kickToClearGoalie and a newKickToClearGoalie Option
 *
 * Revision 1.32  2004/03/24 15:11:36  pg_joke
 * added location dependend kickratings to improve team-behavior
 *
 * Revision 1.31  2004/03/24 12:54:24  pg_joke
 * added GoToBallGoalie
 *
 * Revision 1.30  2004/03/21 04:36:06  pg_joke
 * added slidingAverage to OptionRatings,
 * added ratingBoost (Hysteresis) to OptionRatings
 *
 * Revision 1.29  2004/03/10 21:44:30  kerdels
 * added goToMiddleAtBall Option
 *
 * Revision 1.28  2004/03/01 17:14:07  kerdels
 * added robot-pose.distance-to-opponent-goal,
 * moved robot-pose.angle-to-teammate1-3 to MSH2004StrategySymbols as fieldpos.angle-to-teammate1-3,
 * added fieldpos.distance-to-teammate1-3,
 * added DTT-Options newKickToGoal, newKickToClear, newKickToTeammate1-3,
 * added DTT-OptionClass newKickToTeammate,
 * added kickToPosRating function in DefaultOptionRating
 *
 * Revision 1.27  2004/02/28 11:20:17  kerdels
 * removed single kicks from behavior...
 *
 * Revision 1.26  2004/02/19 17:01:11  kerdels
 * added goalie-switch with two demo-options waveLeft and waveRight
 *
 * Revision 1.25  2004/02/18 23:32:59  kerdels
 * added goToFrontPenLeft, goToFrontPenRight
 * added backUp, not rated yet
 * splittet goto-switch.xml in goto-switch.xml and gotoBall-switch.xml
 *
 * Revision 1.24  2004/02/04 23:26:41  kerdels
 * added kicksToClear, clearkick-switch and option-type, specialKickToClear optionClass and apropriate ratings,
 * modified GoToBallPos ratings
 *
 * Revision 1.23  2004/02/04 17:48:06  kerdels
 * heelKicks removed
 *
 * Revision 1.22  2004/02/04 17:19:00  kerdels
 * added Threshold for OptionClasses
 *
 * Revision 1.21  2004/02/04 16:45:10  kerdels
 * added keepOption
 *
 * Revision 1.20  2004/02/04 15:34:52  rossdeutscher
 * improved overall behaviour
 *
 * Revision 1.19  2004/02/03 12:51:53  lohmann
 * BananaCross splitted into Left and Right.
 *
 * Revision 1.18  2004/02/02 16:33:58  kerdels
 * added DTT-options goToCatenaccioLeft, goToCatenaccioMiddle and goToCatenaccioRight.
 * Also added catfun.dat to test this new options
 *
 * Revision 1.17  2004/02/02 12:23:45  lohmann
 * unsw-bash-optimized-kick added
 *
 * Revision 1.16  2004/01/29 23:56:35  kerdels
 * added special goalie position to DTT
 *
 * Revision 1.15  2004/01/29 21:33:28  kerdels
 * added turn-for-ball Option to DTT,
 * added link between TacticChooser and OptionRating
 *
 * Revision 1.14  2004/01/28 23:27:32  kerdels
 * added rollLeft and rollRight Option to DTT,
 * rating has to be adjusted
 *
 * Revision 1.13  2004/01/28 19:28:26  kerdels
 * hopefully fixed some mysterious bug ...
 *
 * Revision 1.12  2004/01/28 12:43:25  kerdels
 * added kickFun.dat
 * With this TacticEntries 2 Dogs do some kicking exercise :)
 *
 * Revision 1.11  2004/01/28 00:53:01  kerdels
 * added OptionClasses specialKickToGoal and specialKickToTeammate
 *
 * Revision 1.10  2004/01/28 00:01:46  kerdels
 * added legKick, leftKick, rightKick, chestKick, leftHeadKick, rightHeadKick and fastDiveKick to DTT
 *
 * Revision 1.9  2004/01/27 22:26:55  kerdels
 * added fastHeadKicks to DTT
 *
 * Revision 1.8  2004/01/27 14:26:08  lohmann
 * Banana Cross added.
 *
 * Revision 1.7  2004/01/27 02:32:19  kerdels
 * restructuring the restructuring of our xabsl-stuff... +
 * found and removed a bad bug in collectedBeliefs.cpp
 *
 * Revision 1.6  2004/01/26 21:33:31  kerdels
 * added swimKicks
 *
 * Revision 1.5  2004/01/26 20:40:50  kerdels
 * added pawKickRight
 *
 * Revision 1.4  2004/01/26 18:45:05  kerdels
 * added pawKickLeft
 *
 * Revision 1.3  2004/01/26 18:02:17  kerdels
 * added heel-kicks to dtt
 *
 * Revision 1.2  2004/01/25 21:22:56  kerdels
 * added mantisKickToTeammates
 *
 * Revision 1.1  2004/01/25 17:28:24  kindler
 * Added .cpp file for RateableOptions
 *
 */
