/**
 * @file CollectedBeliefs.cpp
 *
 * Implementation of class CollectedBeliefs.
 */

#include "CollectedBeliefs.h"



/** Implementation of SingleBeliefs*/

SingleBeliefs::SingleBeliefs()
{
  int i;
  for (i = 0; i < RateableOptions::numOfOptions; ++i)
    ratedOptions[i].reset(1);
  timeStamp = SystemCall::getCurrentSystemTime();
  for (i = 0; i < RateableOptions::numOfOptionClasses; ++i)
    lastBestOpt[i] = RateableOptions::getClassMember((RateableOptions::OptionClassID)(i+RateableOptions::numOfOptions),0);
}

SingleBeliefs::~SingleBeliefs()
{
}

RateableOptions::OptionID SingleBeliefs::getBestOptionInOptionClass(RateableOptions::OptionClassID id)
{
	RateableOptions::OptionID maxopt = lastBestOpt[(int)(id)-RateableOptions::numOfOptions];
  int maxval = ratedOptions[(int)(maxopt)];
  int ct = RateableOptions::getOptionClassChangeThreshold(id);

  for (int i = 0; i < RateableOptions::getNumberOfClassMembers(id); ++i)
	  if (ratedOptions[(int)(RateableOptions::getClassMember(id,i))] >= (maxval+ct))
		{
		  maxval = ratedOptions[(int)(RateableOptions::getClassMember(id,i))];
			maxopt = RateableOptions::getClassMember(id,i);
		}

  lastBestOpt[(int)(id)-RateableOptions::numOfOptions] = maxopt;
  return maxopt;
}


In& operator>>(In& stream,SingleBeliefs& singleBeliefs)
{
  int tmp = 0;
  for (int i = 0; i < RateableOptions::numOfOptions; ++i){
    stream.read(&tmp,sizeof(int));
    singleBeliefs.ratedOptions[i] = tmp;
  }
  return stream;
}


Out& operator<<(Out& stream,SingleBeliefs& singleBeliefs)
{
  int tmp = 0;
  for (int i = 0; i < RateableOptions::numOfOptions; ++i){
    tmp = singleBeliefs.ratedOptions[i];
    stream.write(&tmp,sizeof(int));
  }
  return stream;
}






/** Implementation of CollectedBeliefs*/

CollectedBeliefs::CollectedBeliefs(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
  for (int i=0; i < Player::numOfPlayerNumbers; ++i) {
    for (int j=0; j < RateableOptions::numOfOptions; ++j) {
      singleBeliefs[i].ratedOptions[j].reset(RateableOptions::getSlidingAverageRange(j));
    }
    singleBeliefs[i].timeStamp = SystemCall::getCurrentSystemTime();
  }

}

CollectedBeliefs::~CollectedBeliefs()
{
}

void CollectedBeliefs::update()
{
	// update the singleBeliefs ...
	// the BehaviorControlInterfaces should provide the needed information...
	// btw: the "own" SingleBeliefs is
	// singleBeliefs[(int)(getPlayer().getPlayerRole())]


  // due to some problems with aging based on timestamps from the other dogs
  // we use the timestamp of the last change in a singleBeliefs structure...
  //bool somethingChanged;

  for (int i=0; i<Player::numOfPlayerNumbers-1; ++i)
  {
    if ((teamMessageCollection[i].isActual()) &&
        (teamMessageCollection[i].playerNumberOfSender != Player::undefinedPlayerNumber))
    {
      SingleBeliefs& actSingleBeliefs =
				singleBeliefs[(int)(teamMessageCollection[i].playerNumberOfSender)];
      /*
      somethingChanged = false;
			for (int j=0; j<RateableOptions::numOfOptions; ++j)
        if (actSingleBeliefs.ratedOptions[j] != 
              teamMessageCollection[i].behaviorTeamMessage.ratedOptions[j])
        {
				  actSingleBeliefs.ratedOptions[j] =
				    teamMessageCollection[i].behaviorTeamMessage.ratedOptions[j];
          somethingChanged = true;
        }
      if (somethingChanged)
			  actSingleBeliefs.timeStamp = SystemCall::getCurrentSystemTime();
        */
			for (int j=0; j<RateableOptions::numOfOptions; ++j)
				  actSingleBeliefs.ratedOptions[j] =
				    teamMessageCollection[i].behaviorTeamMessage.ratedOptions[j];
		  actSingleBeliefs.timeStamp = SystemCall::getCurrentSystemTime();
    }
  }
  
}

void CollectedBeliefs::broadcast()
{
  // broadcast your singleBeliefs
	// maybe use the outgoingBehaviorTeamMessage property for this
  int tmpno = (int)(getPlayer().getPlayerNumber());
  if (tmpno != Player::undefinedPlayerNumber)
  {
    for (int j=0; j<RateableOptions::numOfOptions; ++j)
      outgoingBehaviorTeamMessage.ratedOptions[j] = 
        singleBeliefs[tmpno].ratedOptions[j].getLastValue();

	  INFO(sendOptionRatings,idSingleBeliefs,bin,singleBeliefs[tmpno]);
  }
}

void CollectedBeliefs::trigger()
{
  for (int i=0; i < Player::numOfPlayerNumbers; ++i)
  {
    for (int j=0; j<RateableOptions::numOfOptions; ++j)
      singleBeliefs[i].ratedOptions[j].trigger();
  }
}



In& operator>>(In& stream,CollectedBeliefs& collectedBeliefs)
{
  stream.read(&collectedBeliefs,sizeof(CollectedBeliefs));
  return stream;
}


Out& operator<<(Out& stream, const CollectedBeliefs& collectedBeliefs)
{
  stream.write(&collectedBeliefs,sizeof(CollectedBeliefs));
  return stream;
}


/*
 * Change log :
 *
 * $Log: CollectedBeliefs.cpp,v $
 * Revision 1.19  2004/05/17 17:17:50  kerdels
 * added symbols for the sequence control of the open challenge,
 * fixed a bug concerning 5-dog-mode and distribution of option-ratings,
 * set one = 0 in enum Player::playerNumber --> just to be sure ;-)
 *
 * Revision 1.18  2004/04/08 17:14:27  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.18  2004/03/21 04:36:06  pg_joke
 * added slidingAverage to OptionRatings,
 * added ratingBoost (Hysteresis) to OptionRatings
 *
 * Revision 1.17  2004/03/10 10:53:23  kerdels
 * no comment
 *
 * Revision 1.16  2004/03/09 23:11:12  kerdels
 * unmystified this bug (wasn't mystical at all :-( )
 *
 * Revision 1.15  2004/03/08 01:07:19  roefer
 * Interfaces should be const
 *
 * Revision 1.14  2004/02/05 09:26:23  kerdels
 * modified use of threshold
 *
 * Revision 1.13  2004/02/04 17:19:00  kerdels
 * added Threshold for OptionClasses
 *
 * Revision 1.12  2004/01/28 21:54:11  kerdels
 * fixed aging...
 *
 * Revision 1.11  2004/01/28 19:28:26  kerdels
 * hopefully fixed some mysterious bug ...
 *
 * Revision 1.10  2004/01/27 02:32:19  kerdels
 * restructuring the restructuring of our xabsl-stuff... +
 * found and removed a bad bug in collectedBeliefs.cpp
 *
 * Revision 1.9  2004/01/25 12:17:24  kerdels
 * added first single-kick-option "mantisKick" and modified aging of ratedOptions
 *
 * Revision 1.8  2003/12/28 23:00:12  kerdels
 * tactic chooser berarbeitet
 *
 * Revision 1.7  2003/12/28 19:03:30  kerdels
 * option rating dialog added
 *
 * Revision 1.6  2003/12/21 15:42:31  kerdels
 * getBestOptionInOptionClass erweitert
 *
 * Revision 1.5  2003/12/18 19:50:13  kerdels
 * getBestOptionInOptionClass methode gebastelt
 *
 * Revision 1.4  2003/12/17 20:09:59  kerdels
 * BehaviorTeamMessage um eine Eigenschaft ratedOptions erweitert,
 * CollectedBeliefs.update() und .broadcast() implementiert.
 *
 * Revision 1.3  2003/12/17 16:10:40  kerdels
 * Single/ColelctedBeliefs von unntigem Ballast befreit ;-)
 *
 * Revision 1.2  2003/12/11 16:22:20  kerdels
 * Die DynamicTeamTactic neu strukturiert und ins MSH2004 Behavior integriert..
 *
 * Revision 1.1  2003/12/10 20:46:11  kerdels
 * CollectedBeliefs entfernt
 *
 * Revision 1.3  2003/12/07 14:59:54  kindler
 * Changelog keyword added.
 *
 *
 */
