/**
* @file ColorClasses.h
* Declaration of class ColorClasses
*
* @author <A href=mailto:timlaue@informatik.uni-bremen.de>Tim Laue</A>
* @author Martin Ltzsch
*/

#ifndef __ColorClasses_h__
#define __ColorClasses_h__

#include "Tools/Debugging/DebugDrawings.h"

/** color classes used for objects in the world */
enum colorClass 
{
  noColor, /*<! all other objects */
    orange, /*<! ball */
    yellow, /*<! yellow goal and flag */
    skyblue, /*<! skyblue goal and flag */
    pink, /*<! pink flag */
    red, /*<! red player */
    blue, /*<! blue player */
    green, /*<! playground and green flag */
    gray, /*<! player */
    white, /*<! boundaries and lines */
    black, /*<! for ball-challenge */
    yellowOrange, /*<! ball or yellow goal */
     numOfColors /*<! number of colors */
};

/**
* @class ColorClasses
* 
* Static class for color class functions.
*
* @author <A href=mailto:timlaue@informatik.uni-bremen.de>Tim Laue</A>
* @author Martin Ltzsch
*/
class ColorClasses
{
public:
  /**
   * Returns the RBG-Value for a color class
   * @param color The color class
   * @return The RGB value
   */
  static unsigned long colorClassToRGB(colorClass color)
  {
    int r,g,b;

    switch(color) 
    {
      case orange:  r = 255; g = 128; b = 64;  break;
      case yellow:  r = 255; g = 255; b = 0;   break;
      case skyblue: r = 0;   g = 128; b = 255; break;
      case pink:    r = 255; g = 0;   b = 255; break;
      case red:     r = 255; g = 0;   b = 0;   break;
      case blue:    r = 0;   g = 0;   b = 128; break;
      case gray:    r = 128; g = 128; b = 128; break;
      case green:   r = 0;   g = 255; b = 0;   break;
      case white:   r = 255; g = 255; b = 255; break;
      case black:   r = 0; g = 0; b = 0; break;
      case yellowOrange:   r = 255; g = 192; b = 32; break;
      default: r = 0; g = 96; b = 128; break;
    };

    return b*0x10000+g*0x100+r;
  }

  /**
   * Returns the name of a color class
   * @param color The color class
   * @return The name
   */
  static const char* getColorName(colorClass color)
  {
    switch(color) 
    {
    case noColor: return "no color";
    case orange: return "orange"; 
    case yellow: return "yellow"; 
    case skyblue: return "sky blue"; 
    case pink: return "pink"; 
    case red: return "red";
    case blue: return "blue";
    case green: return "green"; 
    case gray: return "gray";
    case white: return "white";
    case black: return "black";
    case yellowOrange: return "yellowOrange";
    default: return "unknown color!"; 
    };
  }

  static Drawings::Color colorClassToDrawingsColor(colorClass color)
  {
    switch(color) 
    {
    case noColor: return Drawings::black;
    case orange: return Drawings::orange; 
    case yellow: return Drawings::yellow; 
    case skyblue: return Drawings::skyblue;  
    case pink: return Drawings::pink; 
    case red: return Drawings::red; 
    case blue: return Drawings::blue; 
    case green: return Drawings::green; 
    case gray: return Drawings::gray; 
    case white: return Drawings::white; 
    case black: return Drawings::black; 
    case yellowOrange: return Drawings::yellowOrange;
    default: return Drawings::white; 
    };
  }
};

#endif //__ColorClasses_h_

/*
 * $Log: ColorClasses.h,v $
 * Revision 1.2  2003/11/03 20:19:22  juengel
 * Added color class yellowOrange
 *
 * Revision 1.1  2003/10/07 10:13:20  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/06/02 11:38:21  schumann
 * added color black for ball chellenge
 *
 * Revision 1.4  2003/03/06 18:19:34  dueffert
 * reduced amount of warnings drastically by ifdefing global functions
 *
 * Revision 1.3  2002/12/16 13:45:20  dueffert
 * doxygen docu corrected
 *
 * Revision 1.2  2002/11/12 10:49:02  juengel
 * New debug drawing macros - second step
 * -moved /Tools/Debugging/PaintMethods.h and . cpp
 *  to /Visualization/DrawingMethods.h and .cpp
 * -moved DebugDrawing.h and .cpp from /Tools/Debugging/
 *  to /Visualization
 *
 * Revision 1.1  2002/09/10 15:53:58  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/08/31 16:42:13  risler
 * doxygen comments corrected
 *
 * Revision 1.2  2002/07/09 20:08:26  roefer
 * Extract simulation colors from color table
 *
 * Revision 1.1.1.1  2002/05/10 12:40:32  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2002/01/12 00:21:06  tim
 * Threshold verndert
 *
 * Revision 1.1  2001/12/15 01:14:55  tim
 * Datei mit Farbkonstanten und entsprechenden Funktionen angelegt
 *
 */
