/** 
* @file JointDataSequencer.h
*
* Definition of class JointDataSequencer.
*
* @author Max Risler
*/

#ifndef __JOINTDATASEQUENCER_H__
#define __JOINTDATASEQUENCER_H__

#include "Representations/Motion/JointDataSequence.h"

/** 
* @class JointDataSequencer
* A class executing JointDataSequences.
* It derives from JointDataSequence but adds methods to execute the sequence.
*/
class JointDataSequencer : public JointDataSequence
{
public:
  /** Constructor */
  JointDataSequencer();

   /** Assignment operator */
  JointDataSequencer& operator=(const JointDataSequence& other);

  /** write next data from current sequent to jointData */
  void nextSequenceData(JointData& jointData);

  /** start executing the sequence */
  void start();

  /** stop executing the sequence */
  void stop();

  /** returns true if the sequence is being executed */
  bool isRunning();

protected:

  /** interpolate joint data
   * @param jointData stores interpolated data
   * @param from data to start from
   * @param to data to interpolate to
   * @param step index of interpolation step
   * @param len length of interpolation
   */
  void interpolateJointData(
    JointData& jointData,
    const JointData& from, const JointData& to, int step, int len
    );

  /** true if the sequence is being executed */
  bool running;

  /** current position in sequence */
  int sequencePos;

  /** counter for repetition of current sequence line */
  int repetitionCounter;

};

#endif //__JOINTDATASEQUENCER_H__

/*
 * Change log :
 * 
 * $Log: JointDataSequencer.h,v $
 * Revision 1.1  2003/10/07 10:13:21  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:28:10  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1  2003/09/26 11:40:40  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/11/27 13:52:17  dueffert
 * doxygen docu corrected
 *
 * Revision 1.1  2002/09/10 15:53:58  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:32  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2002/02/21 18:02:51  risler
 * added assignment operator
 *
 * Revision 1.2  2002/02/21 17:02:11  risler
 * added comments
 *
 * Revision 1.1  2002/02/21 16:29:21  risler
 * added JointDataSequencer
 *
 *
 */
