/**
 * @file Actuatorport.cpp
 * 
 * Implementation of class Actuatorport
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */

#include "Actuatorport.h"


Actuatorport::Actuatorport(const std::string& name, Actuator* actuator, int portId,
                           double minValue, double maxValue)
{
  this->name = actuator->getFullName() + "." + name;
  this->actuator = actuator;
  this->portId = portId;
  this->minValue = minValue;
  this->maxValue = maxValue;
}

void Actuatorport::setValue(double value)
{
  if(value > maxValue)
  {
    value = maxValue;
  }
  else if(value < minValue)
  {
    value = minValue;
  }
  actuator->setValue(value, portId);
}

/*
 * $Log: Actuatorport.cpp,v $
 * Revision 1.2  2003/12/09 13:40:49  roefer
 * href attribute corrected
 *
 * Revision 1.4  2003/12/09 12:38:25  roefer
 * href attribute corrected
 *
 * Revision 1.3  2003/09/08 22:32:07  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:21  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */