// srConsole.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "SimRobXP.h"
#include "srConsole.h"
#include "srDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConsole 

BEGIN_MESSAGE_MAP(CConsole, CSizingControlBarG)
  //{{AFX_MSG_MAP(CConsole)
  ON_WM_CREATE()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CConsole::Print(const char* text)
{
  while(m_wndChild.GetLineCount() >= 200)
  {
    int n = m_wndChild.LineIndex(0);
    m_wndChild.SetSel(n, n + m_wndChild.LineLength(n) + 2, TRUE);
    m_wndChild.ReplaceSel("");
  }
  int n = m_wndChild.LineIndex(m_wndChild.GetLineCount() - 1);
  n += m_wndChild.LineLength(n);
  m_wndChild.SetSel(n,n);
  m_wndChild.ReplaceSel(text);
  n = m_wndChild.LineIndex(m_wndChild.GetLineCount() - 1);
  n += m_wndChild.LineLength(n);
  m_wndChild.SetSel(n,n,TRUE);
}

void CConsole::Clear()
{
  m_wndChild.SetWindowText("");
}

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CConsole 

int CConsole::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
  if (CSizingControlBarG::OnCreate(lpCreateStruct) == -1)
    return -1;

  SetSCBStyle(GetSCBStyle() | SCBS_SIZECHILD);

  if (!m_wndChild.Create(WS_CHILD|WS_VISIBLE|WS_VSCROLL|
                         ES_MULTILINE|ES_WANTRETURN|ES_AUTOVSCROLL,
                         CRect(0,0,0,0), this, ID_CONSOLE))
    return -1;

  m_wndChild.ModifyStyleEx(0, WS_EX_CLIENTEDGE);

  // older versions of Windows* (NT 3.51 for instance)
  // fail with DEFAULT_GUI_FONT
  if (!m_font.CreateStockObject(DEFAULT_GUI_FONT))
    if(!m_font.CreatePointFont(80, "MS Sans Serif"))
      return -1;

  m_wndChild.SetFont(&m_font);

  return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CConsole 

BEGIN_MESSAGE_MAP(CConsoleEdit, CEdit)
  //{{AFX_MSG_MAP(CConsoleEdit)
  ON_WM_CHAR()
  ON_WM_SETFOCUS()
  ON_WM_KILLFOCUS()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CConsoleEdit::OnChar(UINT nChar,UINT nRepCnt,UINT nFlags)
{
  if(nChar == '\r')
  {
    char buf[100];
    int n = GetLine(LineFromChar(-1),buf,sizeof(buf));
    buf[n] = 0;
    n = LineIndex(-1) + n;
    SetSel(n,n+2);
    CEdit::OnChar(nChar,nRepCnt,nFlags);
    if(CDoc::theDocument)
      CDoc::theDocument->OnConsoleCommand(buf);
  }
  else if(nChar == '\t')
  {
    char buf[200];
    int begin,
        end;
    GetSel(begin, end);
    int n = GetLine(LineFromChar(-1),buf,sizeof(buf));
    buf[begin == end || buf[n - 1] != ' ' ? n : n - 1] = 0;
    if(CDoc::theDocument)
      CDoc::theDocument->OnConsoleCompletion(buf, (GetKeyState(VK_SHIFT) & 0x8000) == 0);
    SetSel(LineIndex(-1), LineIndex(-1) + n);
    ReplaceSel(buf, TRUE);
    n = LineIndex(-1) + strlen(buf);
    SetSel(begin, n);
  }
  else
    CEdit::OnChar(nChar,nRepCnt,nFlags);
}

void CConsoleEdit::OnSetFocus(CWnd* pWnd)
{
  CChild::TranslateChars(FALSE);
  CEdit::OnSetFocus(pWnd);
}

void CConsoleEdit::OnKillFocus(CWnd* pWnd)
{
  CChild::TranslateChars(TRUE);
  CEdit::OnKillFocus(pWnd);
}

