// srActorSlider.cpp : implementation file
//

#include "StdAfx.h"
#include "SimRobXP.h"
#include "srDoc.h"
#include "srActuator.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CActuatorSlider

CActuatorSlider::CActuatorSlider()
{
}

CActuatorSlider::~CActuatorSlider()
{
}


BEGIN_MESSAGE_MAP(CActuatorSlider, CSliderCtrl)
  //{{AFX_MSG_MAP(CActuatorSlider)
  ON_WM_RBUTTONUP()
  ON_WM_PAINT()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CActuatorSlider message handlers

void CActuatorSlider::OnRButtonUp(UINT nFlags, CPoint point) 
{
  GetParent()->SendMessage(WM_RBUTTONUP,nFlags,MAKELONG(point.x,point.y));
}

void CActuatorSlider::OnPaint() 
{
  if(((CActuator*) GetParent())->IsSnap())
    SetPos(((GetPos()+105) / 10) * 10 - 100);
  CSliderCtrl::OnPaint();
  CRect rect;
  GetThumbRect(rect);
  int y = rect.bottom + 6;
  GetClientRect(&rect);
  char c[20];
  sprintf(c,"   %d%%   ",GetPos());
  CClientDC dc(this);
  CFont* pFont = dc.SelectObject(CFont::FromHandle((HFONT) GetStockObject(DEFAULT_GUI_FONT)));
  dc.SetBkColor(GetSysColor(COLOR_BTNFACE));
  dc.TextOut((rect.right - dc.GetTextExtent(c).cx) / 2,y,c);
  dc.TextOut(2,y,GetRangeMin() ? "-100%" : "0%");
  dc.TextOut(rect.right - dc.GetTextExtent("100%").cx - 2,y,"100%");
  dc.SelectObject(pFont);
}
