// srActuator.cpp : implementation file
//

#include "StdAfx.h"
#include "SimRobXP.h"
#include "srDoc.h"
#include "srActuator.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CActuator

IMPLEMENT_DYNCREATE(CActuator, CView)

CActuator::CActuator()
{
  m_ap = -1;
}

CActuator::~CActuator()
{
}

void CActuator::WriteLayout()
{
  CDoc* pDoc = GetDocument();
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  GetParent()->GetWindowPlacement(&wp);
  pDoc->NewSection("actuatorFrame");
  pDoc->WriteInt("flags",wp.flags);
  pDoc->WriteInt("show",wp.showCmd);
  pDoc->WriteInt("top",wp.rcNormalPosition.top);
  pDoc->WriteInt("bottom",wp.rcNormalPosition.bottom);
  pDoc->WriteInt("left",wp.rcNormalPosition.left);
  pDoc->WriteInt("right",wp.rcNormalPosition.right);
  pDoc->WriteInt("minX",wp.ptMinPosition.x);
  pDoc->WriteInt("minY",wp.ptMinPosition.y);
  pDoc->WriteInt("maxX",wp.ptMaxPosition.x);
  pDoc->WriteInt("maxY",wp.ptMaxPosition.y);

  pDoc->NewSection("actuator");
  pDoc->WriteString("actuator",m_sActuator);
  pDoc->WriteInt("snapToGrid",m_bSnap);
  pDoc->WriteInt("position",m_slider.GetPos());
}

bool CActuator::RestoreLayout()
{
  CDoc* pDoc = GetDocument();
  if(!pDoc->IsRestoringLayout())
    return false;
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  pDoc->NewSection("actuatorFrame");
  wp.flags = pDoc->ReadInt("flags");
  wp.showCmd = pDoc->ReadInt("show");
  wp.rcNormalPosition.top = pDoc->ReadInt("top");
  wp.rcNormalPosition.bottom = pDoc->ReadInt("bottom");
  wp.rcNormalPosition.left = pDoc->ReadInt("left");
  wp.rcNormalPosition.right = pDoc->ReadInt("right");
  wp.ptMinPosition.x = pDoc->ReadInt("minX");
  wp.ptMinPosition.y = pDoc->ReadInt("minY");
  wp.ptMaxPosition.x = pDoc->ReadInt("maxX");
  wp.ptMaxPosition.y = pDoc->ReadInt("maxY");
  GetParent()->SetWindowPlacement(&wp);

  pDoc->NewSection("actuator");
  m_sActuator = pDoc->ReadString("actuator");
  m_bSnap = pDoc->ReadInt("snapToGrid") != 0;
  m_slider.SetPos(pDoc->ReadInt("position"));
  return true;
}

BEGIN_MESSAGE_MAP(CActuator, CView)
  //{{AFX_MSG_MAP(CActuator)
  ON_WM_RBUTTONUP()
  ON_COMMAND(ID_VIEW_SNAP, OnViewSnap)
  ON_UPDATE_COMMAND_UI(ID_VIEW_SNAP, OnUpdateViewSnap)
  ON_WM_ERASEBKGND()
  ON_WM_SIZE()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CActuator drawing

void CActuator::OnDraw(CDC* pDC)
{
  CDocument* pDoc = GetDocument();
  // TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CActuator diagnostics

#ifdef _DEBUG
void CActuator::AssertValid() const
{
  CView::AssertValid();
}

void CActuator::Dump(CDumpContext& dc) const
{
  CView::Dump(dc);
}

CDoc* CActuator::GetDocument() // non-debug version is inline
{
  ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDoc)));
  return (CDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CActuator message handlers

void CActuator::OnInitialUpdate() 
{
  CRect rect,rect2;
  GetClientRect(&rect);
  m_slider.Create(TBS_HORZ | TBS_AUTOTICKS | TBS_BOTTOM | TBS_ENABLESELRANGE,rect,this,0);
  m_slider.SetRange(-100,100);
  m_slider.SetLineSize(10);
  m_slider.SetPageSize(100);
  m_slider.SetTicFreq(10);
  if(!RestoreLayout())
  {
    m_sActuator = GetDocument()->GetSelectedObject();
    m_slider.GetThumbRect(rect);
    GetParent()->GetParent()->GetClientRect(&rect2);
    CClientDC dc(this);
    CFont* pFont = dc.SelectObject(CFont::FromHandle((HFONT) GetStockObject(DEFAULT_GUI_FONT)));
    GetParent()->SetWindowPos(0,0,0,rect2.right / 5,
                              dc.GetTextExtent("1").cy + 7 + rect.bottom + 
                              GetSystemMetrics(SM_CYCAPTION) + 
                              2 * (GetSystemMetrics(SM_CYSIZEFRAME) + GetSystemMetrics(SM_CYEDGE)),
                              SWP_NOZORDER | SWP_NOMOVE | SWP_NOREDRAW);
    dc.SelectObject(pFont);
    m_bSnap = 1;
  }
  CString s = "Actuator - ";
  GetParent()->ModifyStyle(FWS_ADDTOTITLE,0);
  GetParent()->SetWindowText(s + m_sActuator);
  m_menuPopup.LoadMenu(IDP_ACTUATOR);
  m_slider.ShowWindow(SW_NORMAL);
  CView::OnInitialUpdate();
}

void CActuator::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
  Simulation* pSim = GetDocument()->GetSimulation();
  if(lHint == UPDATE_ACTORS)
  {
    
    if(!GetParent()->IsIconic() && m_ap != -1)
    {
      double origin,
             offset;
      if(pSim->getActuatorportMinValue(m_ap) >= 0)
      {
        origin = pSim->getActuatorportMinValue(m_ap);
        offset = pSim->getActuatorportMaxValue(m_ap) - pSim->getActuatorportMinValue(m_ap);
      }
      else if(pSim->getActuatorportMaxValue(m_ap) <= 0)
      {
        origin = pSim->getActuatorportMaxValue(m_ap);
        offset = pSim->getActuatorportMaxValue(m_ap) - pSim->getActuatorportMinValue(m_ap);
      }
      else if(m_slider.GetPos() < 0)
      {
        origin = 0;
        offset = -pSim->getActuatorportMinValue(m_ap);
      }
      else
      {
        origin = 0;
        offset = pSim->getActuatorportMaxValue(m_ap);
      }
      pSim->setActuatorport(m_ap,m_slider.GetPos() / 100.0 * offset + origin);
    }
  }
  else if(lHint != UPDATE_SENSORS && lHint != UPDATE_OBJECTS)
  {
    if(GetDocument()->GetType(m_sActuator) == OBJECT_TYPE_ACTUATORPORT)
    {
      m_ap = pSim->getActuatorportId((const char*) m_sActuator);
      if(pSim->getActuatorportMinValue(m_ap) >= 0)
        m_slider.SetRange(0,100,true);
      else if(pSim->getActuatorportMaxValue(m_ap) <= 0)
        m_slider.SetRange(-100,0,true);
      else      
        m_slider.SetRange(-100,100,true);
    }
    else
      m_ap = -1;
    m_slider.EnableWindow(m_ap != -1);
    Invalidate(false);
  }
}

void CActuator::OnRButtonUp(UINT nFlags, CPoint point) 
{
  ClientToScreen(&point);
  m_menuPopup.GetSubMenu(0)
    ->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
                     point.x,point.y,AfxGetMainWnd());
}

void CActuator::OnViewSnap() 
{
  if(m_ap != -1)
  {
    m_bSnap ^= true;
    Invalidate(false);
  }
}

void CActuator::OnUpdateViewSnap(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(m_ap != -1);
  pCmdUI->SetCheck(m_bSnap);
}

BOOL CActuator::OnEraseBkgnd(CDC* pDC) 
{
  return true;
}

void CActuator::OnSize(UINT nType, int cx, int cy) 
{
  CView::OnSize(nType, cx, cy);
  if(m_slider.m_hWnd)
    m_slider.SetWindowPos(0,0,0,cx,cy,SWP_NOZORDER | SWP_NOMOVE | SWP_NOREDRAW);
}
