/////////////////////////////////////////////////////////////////////////////
// WindowListDialog.h: interface for the CWindowListDialog class.
//
/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001 by Nikolay Denisov. All rights reserved.
//
// This code is free for personal and commercial use, providing this 
// notice remains intact in the source files and all eventual changes are
// clearly marked with comments.
//
// You must obtain the author's consent before you can include this code
// in a software library.
//
// No warrantee of any kind, express or implied, is included with this
// software; use at your own risk, responsibility for damages (if any) to
// anyone resulting from the use of this software rests entirely with the
// user.
//
// Please email bug reports, bug fixes, enhancements, requests and
// comments to: nick@actor.ru
/////////////////////////////////////////////////////////////////////////////

#ifndef __WINDOWLISTDIALOG_H__
#define __WINDOWLISTDIALOG_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CommonRes.h"

/////////////////////////////////////////////////////////////////////////////
// CWindowListDialog dialog

class CWindowListDialog : public CDialog
{
// Construction
public:
    CWindowListDialog( CWnd* pMDIClientWnd, CWnd* pParent = 0 );

// Dialog Data
    //{{AFX_DATA(CWindowListDialog)
    enum { IDD = IDD_WINDOW_LIST };
    CButton m_bnMinimize;
    CButton m_bnTileVert;
    CButton m_bnTileHorz;
    CButton m_bnCascade;
    CButton m_bnCloseWin;
    CButton m_bnSave;
    CButton m_bnActivate;
    CListCtrl   m_lstWindows;
    //}}AFX_DATA

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CWindowListDialog)
    protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    //}}AFX_VIRTUAL

// Implementation
protected:
    void ReloadWindowList();
    void Activate( int nItem );
    void ArrangeWindows( UINT nMsg, WPARAM wParam = 0, LPARAM lParam = 0 );

// Implementation data
protected:
    CWnd*       m_pMDIClientWnd;
    CImageList  m_imageList;

// Generated message map functions
protected:
    //{{AFX_MSG(CWindowListDialog)
    virtual BOOL OnInitDialog();
    afx_msg void OnActivate();
    afx_msg void OnSave();
    afx_msg void OnCloseWin();
    afx_msg void OnCascade();
    afx_msg void OnTileHorz();
    afx_msg void OnTileVert();
    afx_msg void OnMinimize();
    afx_msg void OnDblClkWindows(NMHDR* pNMHDR, LRESULT* pResult);
    //}}AFX_MSG
    afx_msg void OnKickIdle();
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif // !__WINDOWLISTDIALOG_H__
