/////////////////////////////////////////////////////////////////////////////
// BmpMenuOwnerWnd.h: interface for the CBmpMenuOwnerWnd class.
//
/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001 by Nikolay Denisov. All rights reserved.
//
// This code is free for personal and commercial use, providing this 
// notice remains intact in the source files and all eventual changes are
// clearly marked with comments.
//
// You must obtain the author's consent before you can include this code
// in a software library.
//
// No warrantee of any kind, express or implied, is included with this
// software; use at your own risk, responsibility for damages (if any) to
// anyone resulting from the use of this software rests entirely with the
// user.
//
// Please email bug reports, bug fixes, enhancements, requests and
// comments to: nick@actor.ru
/////////////////////////////////////////////////////////////////////////////

#ifndef __BMPMENUOWNERWND_H__
#define __BMPMENUOWNERWND_H__

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "WinAppEx.h"

/////////////////////////////////////////////////////////////////////////////
// CBmpMenuOwnerWnd

template< class TBase >
class CBmpMenuOwnerWnd : public TBase
{
// Constructors
public:
    CBmpMenuOwnerWnd();
    ~CBmpMenuOwnerWnd();

// Message map functions
protected:
    afx_msg void OnInitMenuPopup( CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu );
    afx_msg void OnDrawItem( int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct );
    afx_msg void OnMeasureItem( int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct );
};

/////////////////////////////////////////////////////////////////////////////
// CBmpMenuOwnerWnd out-of-line functions

template< class TBase >
CBmpMenuOwnerWnd< TBase >::CBmpMenuOwnerWnd()
{
}

template< class TBase >
CBmpMenuOwnerWnd< TBase >::~CBmpMenuOwnerWnd()
{
}

template< class TBase >
void CBmpMenuOwnerWnd< TBase >::OnInitMenuPopup( CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu )
{
    TBase::OnInitMenuPopup( pPopupMenu, nIndex, bSysMenu );

    CWinAppEx::GetInstance()->SetMenuIcons( pPopupMenu );
}

template< class TBase >
void CBmpMenuOwnerWnd< TBase >::OnDrawItem( int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct )
{
    CWinAppEx* pApp = CWinAppEx::GetInstance();
    if ( pApp->GetBitmappedMenus() && ( lpDrawItemStruct->CtlType == ODT_MENU ) )
    {
        int nImage = pApp->GetMenuImage( lpDrawItemStruct->itemID );
        if ( nImage != -1 )
        {
            CDC* pDC = CDC::FromHandle( lpDrawItemStruct->hDC );
            CRect rcItem( &lpDrawItemStruct->rcItem );
            bool bSelected = ( lpDrawItemStruct->itemState & ODS_SELECTED ) != 0;
            bool bGrayed   = ( lpDrawItemStruct->itemState & ODS_GRAYED   ) != 0;

            if ( bGrayed )
            {
                CBrush brush( ::GetSysColor( bSelected ? COLOR_GRAYTEXT : COLOR_BTNTEXT ) );
                CBrush* pOldBrush = pDC->SelectObject( &brush );

                CWindowDC dcWin( 0 );

                CDC dc;
                VERIFY( dc.CreateCompatibleDC( &dcWin ) );

                CBitmap bmp;
                VERIFY( bmp.CreateCompatibleBitmap( &dcWin,
                    szMenuIcon.cx, szMenuIcon.cy ) );
                CBitmap* pOldBitmap = dc.SelectObject( &bmp );

                VERIFY( dc.PatBlt( 0, 0,
                    szMenuIcon.cx, szMenuIcon.cy, WHITENESS ) );
                VERIFY( pApp->GetMenuImageList()->Draw( &dc, nImage, CPoint( 0, 0 ), ILD_NORMAL ) );
                VERIFY( pDC->BitBlt( rcItem.left, rcItem.top,
                    szMenuIcon.cx, szMenuIcon.cy, &dc, 0, 0, ROP_PSDPxax ) );

                dc.SelectObject( pOldBitmap );
                VERIFY( bmp.DeleteObject() );

                pDC->SelectObject( pOldBrush );
                VERIFY( brush.DeleteObject() );
            }
            else
            {
                VERIFY( pApp->GetMenuImageList()->Draw( pDC, nImage, rcItem.TopLeft(),
                    bSelected ? ILD_BLEND25 : ILD_NORMAL ) );
            }
        }
    }
    else
    {
        TBase::OnDrawItem( nIDCtl, lpDrawItemStruct );
    }
}

template< class TBase >
void CBmpMenuOwnerWnd< TBase >::OnMeasureItem( int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct )
{
    CWinAppEx* pApp = CWinAppEx::GetInstance();
    if ( pApp->GetBitmappedMenus() && ( lpMeasureItemStruct->CtlType == ODT_MENU ) )
    {
        lpMeasureItemStruct->itemWidth  = szMenuIcon.cx + 4;
        lpMeasureItemStruct->itemHeight = szMenuIcon.cy;
    }
    else
    {
        TBase::OnMeasureItem( nIDCtl, lpMeasureItemStruct );
    }
}

/////////////////////////////////////////////////////////////////////////////
#endif  // !__BMPMENUOWNERWND_H__
