#include "StdAfx.h"
#include "../Controller/Controller.h"
#include "srDoc.h"
#include "srObject.h"
#include "srBar.h"
#include "srConsole.h"
#include "srFrame.h"
#include "../SimRobotCore/Simulation.h"

Controller::Controller()
{
  POSITION pos = AfxGetApp()->GetFirstDocTemplatePosition();
  CDocTemplate* pTempl = AfxGetApp()->GetNextDocTemplate(pos);
  pos = pTempl->GetFirstDocPosition();
  CDoc* pDoc = (CDoc*) pTempl->GetNextDoc(pos);
  simulation = pDoc->GetSimulation();
}

Controller::~Controller()
{
}

std::string Controller::getSimulationFileName() const
{
  return simulation->getSimulationFileName();
}

unsigned int Controller::getSimulationStep() const
{
  return simulation->getSimulationStep();
}

Surface* Controller::getSurface(const std::string& name) const
{
  return simulation->getSurface(name);
}

SimObject* Controller::getObjectReference(const std::string& objectName)
{
  return simulation->getObjectReference(objectName);
}

void Controller::setBackgroundColor(const Vector3d& color)
{
  simulation->setBackgroundColor(color);
}

void Controller::setAmbientColor(const Vector3d& color)
{
  simulation->setAmbientColor(color);
}

int Controller::getActuatorportId(std::string portName) const
{
  return simulation->getActuatorportId(portName);
}

double Controller::getActuatorportMinValue(int id) const
{
  return simulation->getActuatorportMinValue(id);
}

double Controller::getActuatorportMaxValue(int id) const
{
  return simulation->getActuatorportMaxValue(id);
}

void Controller::setActuatorport(int id, double value)
{
  simulation->setActuatorport(id, value);
}

int Controller::getSensorportId(std::string portName) const
{
  return simulation->getSensorportId(portName);
}

const std::vector<int>& Controller::getSensorDimensions(int id) const
{
  return simulation->getSensorDimensions(id);
}

void Controller::getSensorValue(int id, bool& value)
{
  simulation->getSensorportValue(id, value);
}

void Controller::getSensorValue(int id, double& value)
{
  simulation->getSensorportValue(id, value);
}

void Controller::getSensorValue(int id, int& value)
{
  simulation->getSensorportValue(id, value);
}

void Controller::getSensorValue(int id, double*& value)
{
  simulation->getSensorportValue(id, value);
}

void Controller::getSensorValue(int id, unsigned char*& value)
{
  simulation->getSensorportValue(id, value);
}

void Controller::addView(View* view, const std::string& name)
{
  simulation->addView(view, name);
}

void Controller::print(const std::string& text)
{
  ((CFrame*) AfxGetMainWnd())->m_wndConsoleBar.Print(text.c_str());
}

void Controller::printLn(const std::string& text)
{
  print(text + "\r\n");
}

void Controller::clear()
{
  ((CFrame*) AfxGetMainWnd())->m_wndConsoleBar.Clear();
}
