/**
 * @file Router/Router.cpp
 *
 * Implementation of class Router.
 *
 * @author <a href="mailto:roefer@tzi.de">Thomas Rfer</a>
 */

#include "Router.h"
#include <errno.h>
#include <fcntl.h>
#include <iostream>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/types.h>

Router::Router()
: INIT_RECEIVER(MessageQueue1,false),
  INIT_SENDER(MessageQueue1,false),

  INIT_RECEIVER(MessageQueue2,false),
  INIT_SENDER(MessageQueue2,false),

  INIT_RECEIVER(MessageQueue3,false),
  INIT_SENDER(MessageQueue3,false),

  INIT_RECEIVER(MessageQueue4,false),
  INIT_SENDER(MessageQueue4,false),

  INIT_RECEIVER(MessageQueue5,false),
  INIT_SENDER(MessageQueue5,false),

  INIT_RECEIVER(MessageQueue6,false),
  INIT_SENDER(MessageQueue6,false),

  INIT_RECEIVER(MessageQueue7,false),
  INIT_SENDER(MessageQueue7,false),

  INIT_RECEIVER(MessageQueue8,false),
  INIT_SENDER(MessageQueue8,false),

  INIT_RECEIVER(CMUData1,false),
  INIT_SENDER(CMUData1,false),

  INIT_RECEIVER(CMUData2,false),
  INIT_SENDER(CMUData2,false),

  INIT_RECEIVER(CMUData3,false),
  INIT_SENDER(CMUData3,false),

  INIT_RECEIVER(CMUData4,false),
  INIT_SENDER(CMUData4,false)
{
  receiver[0] = &theMessageQueue1Receiver;
  sender[0] = &theMessageQueue1Sender;
  receiver[1] = &theMessageQueue2Receiver;
  sender[1] = &theMessageQueue2Sender;
  receiver[2] = &theMessageQueue3Receiver;
  sender[2] = &theMessageQueue3Sender;
  receiver[3] = &theMessageQueue4Receiver;
  sender[3] = &theMessageQueue4Sender;
  receiver[4] = &theMessageQueue5Receiver;
  sender[4] = &theMessageQueue5Sender;
  receiver[5] = &theMessageQueue6Receiver;
  sender[5] = &theMessageQueue6Sender;
  receiver[6] = &theMessageQueue7Receiver;
  sender[6] = &theMessageQueue7Sender;
  receiver[7] = &theMessageQueue8Receiver;
  sender[7] = &theMessageQueue8Sender;

  numOfRobots = 0;
  InConfigFile stream("./ip.txt");
  ASSERT(stream.exists());
  char buf[100];
  while(!stream.eof())
  {
    stream >> buf; // ip-address
    if(strcmp(buf,"---"))
    {
      ASSERT(numOfRobots < 8);
      receiver[numOfRobots]->setSize(1000000);
      sender[numOfRobots]->setSize(200000);
      int port,
          ignore;
      VERIFY(sscanf(buf,"%d.%d.%d.%d",&ignore,&ignore,&ignore,&port) == 4);
      tcp[numOfRobots++] = new TcpConnection("127.0.0.1",15000 + port);
    }
  }
}

Router::~Router()
{
  for(int robot = 0; robot < numOfRobots; ++robot)
    delete tcp[robot];
}

int Router::processMain()
{
  for(int robot = 0; robot < numOfRobots; ++robot)
  {
    char* sendData,
        * receivedData;
    int sendSize = 0,
        receivedSize = 0;

    // If there is something to send, prepare a package
    if(!receiver[robot]->isEmpty())
    {
      if(queueFillRequest.mode == QueueFillRequest::overwriteOlder)
        receiver[robot]->removeRepetitions();
      OutBinarySize size;
      size << *receiver[robot];
      sendSize = size.getSize();
      sendData = new char[sendSize];
      OutBinaryMemory stream(sendData);
      stream << *receiver[robot];
    }

    // exchange data with the Windows program
    if(tcp[robot]->sendAndReceive(sendData,sendSize,receivedData,receivedSize))
      receiver[robot]->clear(); // If sent, empty receiver queue

    // If a package was prepared, remove it
    if(sendSize)
      delete [] sendData;

    // If a package was received from the Windows program, add it to sender queue
    if(receivedSize > 0)
    {
      InBinaryMemory stream(receivedData,receivedSize);
      MessageQueue queue;
      stream >> queue;
      queue.handleSpecificMessages(idQueueFillRequest,*this);
      queue.moveAllMessages(*sender[robot]);
      delete [] receivedData;
    }
  }

  // send all data received to the robots
  theMessageQueue1Sender.send();
  theMessageQueue2Sender.send();
  theMessageQueue3Sender.send();
  theMessageQueue4Sender.send();
  theMessageQueue5Sender.send();
  theMessageQueue6Sender.send();
  theMessageQueue7Sender.send();
  theMessageQueue8Sender.send();

  handleCMUMessages();

  return 1; // wait 1 ms
}

bool Router::handleMessage(InMessage& queue)
{
  queue.bin >> queueFillRequest;
  return true;
}

void Router::handleCMUMessages()
{
  if(theCMUData1Receiver.receivedNew() && !theCMUData1Receiver.isEmpty())
  {
    cmuData2.insert(theCMUData1Receiver);
    cmuData3.insert(theCMUData1Receiver);
    cmuData4.insert(theCMUData1Receiver);
  }

  if(theCMUData2Receiver.receivedNew() && !theCMUData2Receiver.isEmpty())
  {
    cmuData1.insert(theCMUData2Receiver);
    cmuData3.insert(theCMUData2Receiver);
    cmuData4.insert(theCMUData2Receiver);
  }

  if(theCMUData3Receiver.receivedNew() && !theCMUData3Receiver.isEmpty())
  {
    cmuData1.insert(theCMUData3Receiver);
    cmuData2.insert(theCMUData3Receiver);
    cmuData4.insert(theCMUData3Receiver);
  }

  if(theCMUData4Receiver.receivedNew() && !theCMUData4Receiver.isEmpty())
  {
    cmuData1.insert(theCMUData4Receiver);
    cmuData2.insert(theCMUData4Receiver);
    cmuData3.insert(theCMUData4Receiver);
  }

  List<CMUData>::Pos i = cmuData1.getFirst();
  if(cmuData1.getSize() > 8)
    cmuData1.remove(i);
  if(i && theCMUData1Sender.requestedNew())
  {
    (CMUData&) theCMUData1Sender = cmuData1[i];
    theCMUData1Sender.send();
    cmuData1.remove(i);
  }

  i = cmuData2.getFirst();
  if(cmuData2.getSize() > 8)
    cmuData2.remove(i);
  if(i && theCMUData2Sender.requestedNew())
  {
    (CMUData&) theCMUData2Sender = cmuData2[i];
    theCMUData2Sender.send();
    cmuData2.remove(i);
  }
  
  i = cmuData3.getFirst();
  if(cmuData3.getSize() > 8)
    cmuData3.remove(i);
  if(i && theCMUData3Sender.requestedNew())
  {
    (CMUData&) theCMUData3Sender = cmuData3[i];
    theCMUData3Sender.send();
    cmuData3.remove(i);
  }
  
  i = cmuData4.getFirst();
  if(cmuData4.getSize() > 8)
    cmuData4.remove(i);
  if(i && theCMUData4Sender.requestedNew())
  {
    (CMUData&) theCMUData4Sender = cmuData4[i];
    theCMUData4Sender.send();
    cmuData4.remove(i);
  }
}

MAKE_PROCESS(Router);

/*
 * Change log :
 * 
 * $Log: Router.cpp,v $
 * Revision 1.2  2003/12/19 12:43:49  roefer
 * error: overwriteOlder was default
 *
 * Revision 1.1  2003/10/07 10:11:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/08/17 18:35:37  roefer
 * Communication with router standardized and synchronized
 *
 * Revision 1.1.1.1  2003/07/02 09:40:27  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.6  2003/05/29 19:36:39  roefer
 * Support for CMU added
 *
 * Revision 1.5  2003/05/29 12:45:51  roefer
 * Allow --- between IPs in ip.txt
 *
 * Revision 1.4  2003/04/08 11:00:18  roefer
 * ip.txt is located in current directory
 *
 * Revision 1.3  2002/10/24 12:29:50  roefer
 * Default search path changed
 *
 * Revision 1.2  2002/10/07 11:21:46  dueffert
 * includes corrected for gcc3.2
 *
 * Revision 1.1  2002/09/10 15:52:17  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.9  2002/08/04 17:53:18  roefer
 * SimGT2002 connection to physical robots added
 *
 * Revision 1.8  2002/08/01 12:52:27  roefer
 * RouterCtrl and TcpConnection added
 *
 * Revision 1.7  2002/07/23 16:40:12  roefer
 * Router and SimGT2002 adapted to new message queue and streams
 *
 * Revision 1.6  2002/07/23 13:46:06  loetzsch
 * - new streaming classes
 *
 * Revision 1.5  2002/06/09 10:26:15  Thomas Rfer
 * Multi router
 *
 * Revision 1.4  2002/06/08 07:40:19  dueffert
 * queue size increased
 *
 * Revision 1.3  2002/05/28 16:16:36  roefer
 * Sender for GameControlData removed
 *
 * Revision 1.2  2002/05/25 22:52:19  roefer
 * WLan, first working approach
 *
 * Revision 1.1.1.1  2002/05/10 12:40:27  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2002/05/02 18:11:11  roefer
 * New router
 *
 *
 */
