/**
* @file RobotRemoteDlg.cpp
*
* Implementation of the RobotRemote dialogs
*
* @author Martin Ltzsch
*/


#include "stdafx.h"
#include "RobotRemote.h"
#include "RobotRemoteDlg.h"
#include "RobotControl/Visualization/ImageMethods.h"


CRobotRemoteDlg1::CRobotRemoteDlg1(CWnd* pParent /*=NULL*/)
	: CDialog(CRobotRemoteDlg1::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRobotRemoteDlg1)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRobotRemoteDlg1::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRobotRemoteDlg1)
	DDX_Control(pDX, IDC_JOYSTICK_COMBO, m_joystickCombo);
	DDX_Control(pDX, IDC_CONFIGURATION_COMBO, m_configurationCombo);
	DDX_Control(pDX, IDC_JOYSTICK_BITMAP2, m_JoystickBitmap2);
	DDX_Control(pDX, IDC_CONNECT_BITMAP2, m_ConnectBitmap2);
	DDX_Control(pDX, IDC_CONNECT_BITMAP, m_ConnectBitmap);
	DDX_Control(pDX, IDC_JOYSTICK_BITMAP, m_JoystickBitmap);
	DDX_Control(pDX, IDC_IPADDRESS, m_IpControl);
	DDX_Control(pDX, IDC_CONNECT_BUTTON, m_ConnectButton);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRobotRemoteDlg1, CDialog)
	//{{AFX_MSG_MAP(CRobotRemoteDlg1)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_CONNECT_BUTTON, OnConnectButton)
	ON_NOTIFY(IPN_FIELDCHANGED, IDC_IPADDRESS, OnFieldchangedIpaddress)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_CBN_SELCHANGE(IDC_JOYSTICK_COMBO, OnSelchangeJoystickCombo)
	ON_CBN_SELCHANGE(IDC_CONFIGURATION_COMBO, OnSelchangeConfigurationCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CRobotRemoteDlg1::update()
{
  if (getRobotRemoteApp()->joystickIsConnected)
  {
    m_JoystickBitmap.ShowWindow(SW_HIDE);
    m_JoystickBitmap2.ShowWindow(SW_NORMAL);
  }
  else
  {
    m_JoystickBitmap.ShowWindow(SW_NORMAL);
    m_JoystickBitmap2.ShowWindow(SW_HIDE);
  }

  if (getRobotRemoteApp()->wlanIsConnected)
  {
    m_ConnectBitmap.ShowWindow(SW_HIDE);
    m_ConnectBitmap2.ShowWindow(SW_NORMAL);
    m_IpControl.EnableWindow(false);
    m_ConnectButton.EnableWindow(false);
  }
  else
  {
    m_ConnectBitmap.ShowWindow(SW_NORMAL);
    m_ConnectBitmap2.ShowWindow(SW_HIDE);
    m_IpControl.EnableWindow(true);
    m_ConnectButton.EnableWindow(true);
  }

}

BOOL CRobotRemoteDlg1::OnInitDialog()
{
	CDialog::OnInitDialog();

  SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden

  SetTimer(0,50,NULL);
	
  m_IpControl.SetAddress(getRobotRemoteApp()->ip);

  m_joystickCombo.AddString("1");
  m_joystickCombo.AddString("2");
  m_joystickCombo.AddString("3");
  m_joystickCombo.AddString("4");
  m_joystickCombo.SetCurSel(getRobotRemoteApp()->joystick);

  m_configurationCombo.AddString("no images");
  m_configurationCombo.AddString("some images");
  m_configurationCombo.AddString("all images");
  m_configurationCombo.SetCurSel(getRobotRemoteApp()->configuration);
  update();
  
	return TRUE;  
}

void CRobotRemoteDlg1::OnSysCommand(UINT nID, LPARAM lParam)
{
  CDialog::OnSysCommand(nID, lParam);
}


void CRobotRemoteDlg1::OnPaint() 
{
  CDialog::OnPaint();
}

void CRobotRemoteDlg1::OnConnectButton() 
{
  getRobotRemoteApp()->wlanThread.wlanConnect(getRobotRemoteApp()->ip,0xA1BD);
}

void CRobotRemoteDlg1::OnFieldchangedIpaddress(NMHDR* pNMHDR, LRESULT* pResult) 
{
  m_IpControl.GetAddress(getRobotRemoteApp()->ip);
	
	*pResult = 0;
}

void CRobotRemoteDlg1::OnTimer(UINT nIDEvent) 
{
 	getRobotRemoteApp()->OnIdle();
	
	CDialog::OnTimer(nIDEvent);
}


void CRobotRemoteDlg1::OnDestroy() 
{
  KillTimer(0);

	CDialog::OnDestroy();
	
}




CRobotRemoteDlg2::CRobotRemoteDlg2(CWnd* pParent /*=NULL*/)
	: CDialog(CRobotRemoteDlg2::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRobotRemoteDlg2)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRobotRemoteDlg2::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRobotRemoteDlg2)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRobotRemoteDlg2, CDialog)
	//{{AFX_MSG_MAP(CRobotRemoteDlg2)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CRobotRemoteDlg2::update()
{
  RedrawWindow(NULL, NULL, RDW_INVALIDATE);
}

BOOL CRobotRemoteDlg2::OnInitDialog()
{
	CDialog::OnInitDialog();

  SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden

  SetTimer(0,50,NULL);
	
  update();
  
	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

void CRobotRemoteDlg2::OnSysCommand(UINT nID, LPARAM lParam)
{
  CDialog::OnSysCommand(nID, lParam);
}


void CRobotRemoteDlg2::OnPaint() 
{
  CPaintDC dc(this); // device context for painting

  ImageMethods::paintImage2CDCAsYUV(
    dc, getRobotRemoteApp()->image,
    CRect(416, 0, 
    416 + 416, // 416 = 2 * 208
     320) ); // 320 = 2 * 160

  CDialog::OnPaint();
}

void CRobotRemoteDlg2::OnTimer(UINT nIDEvent) 
{
  KillTimer(0);
	CDialog::OnTimer(nIDEvent);
 	getRobotRemoteApp()->OnIdle();
	SetTimer(0,200,NULL);
}

void CRobotRemoteDlg2::OnDestroy() 
{
	CDialog::OnDestroy();
}


void CRobotRemoteDlg1::OnSelchangeJoystickCombo() 
{
  getRobotRemoteApp()->joystick = m_joystickCombo.GetCurSel();
}

void CRobotRemoteDlg1::OnSelchangeConfigurationCombo() 
{
  getRobotRemoteApp()->configuration = 
    (CRobotRemoteApp::Configuration)m_configurationCombo.GetCurSel();
  getRobotRemoteApp()->onChangeConfiguration();
}

/** 
* Change Log:
*
* $Log: RobotRemoteDlg.cpp,v $
* Revision 1.3  2004/05/24 15:40:41  thomas
* added combo-box to support for multiple joysticks
*
* Revision 1.2  2004/04/28 16:12:35  thomas
* switched y- and z-axis in joystick-behavior
* added restoring of solution from module.cfg before disconnect
* remove model-specific image-settings
*
* Revision 1.1  2004/04/26 15:58:59  thomas
* added new project RobotRemote based on ATHAiboControl
*
* Revision 1.3  2004/01/26 13:35:02  loetzsch
* improved
*
* Revision 1.2  2004/01/24 20:18:40  loetzsch
* improved ATH AiboControl
*
* Revision 1.1  2004/01/24 14:55:28  loetzsch
* created ATH AiboControl
*
*/


