/** 
 * @file DebugDrawingManagerUI.h
 *
 * Declaration of class DebugDrawingManagerUI.
 *
 * @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
 */

#ifndef __DebugDrawingManagerUI_h_
#define __DebugDrawingManagerUI_h_

#include "DebugDrawingManagerEnums.h"
/**
* Provides a user interface for debug drawings
* @author Matthias Jngel
*/
class DebugDrawingManagerUI
{
public:

  /** 
  * Shows a context menu for field drawing papers.
  * @param drawingPaper the id of the paper
  * @param point the point of the right-click
  * @param pParent a pointer to the parent window
  */
  static void showContextMenu(
    DrawingPapers::FieldDrawingPaper drawingPaper, 
    CPoint point,
    CFrameWnd* pParent
    );

  /** 
  * Shows a context menu for field drawing papers.
  * @param drawingPaper the id of the paper
  * @param point the point of the right-click
  * @param pParent a pointer to the parent window
  */
  static void showContextMenu(
    DrawingPapers::ImageDrawingPaper drawingPaper, 
    CPoint point,
    CFrameWnd* pParent
    );
};

#endif //DebugDrawingManagerUI_h



/*
 * Change log :
 * 
 * $Log: DebugDrawingManagerUI.h,v $
 * Revision 1.1  2003/10/07 10:11:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:27  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2002/12/18 16:22:56  dueffert
 * doxygen docu corrected
 *
 * Revision 1.2  2002/09/20 23:28:34  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.1  2002/09/10 15:49:12  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.2  2002/06/10 12:00:42  dueffert
 * commentation bugs fixed
 *
 * Revision 1.1.1.1  2002/05/10 12:40:27  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2002/02/10 12:45:15  loetzsch
 * radar viewer and percept visualization continued
 *
 * Revision 1.2  2002/02/08 13:28:08  loetzsch
 * Visualization of PerceptCollection and RadarViewer started
 * (not implemented yet)
 *
 * Revision 1.1  2002/01/26 18:07:33  juengel
 * no message
 *
 * Revision 1.1  2002/01/04 14:35:32  juengel
 * no message
 *
 *
 */
