/**
* @file SimRobotDocument.h
*
* Declaration of class CSimRobotDocument
*
* @author Thomas Rfer
* @author Martin Ltzsch
*/

#ifndef __SimRobotDocument_h_
#define __SimRobotDocument_h_

#include "StdAfx.h"
#include "Controller.h"

#define UPDATE_INIT 0
#define UPDATE_ERROR 1
#define UPDATE_SUCCESS 2
#define UPDATE_ACTORS 3
#define UPDATE_SENSORS 4

class CSimulatorObjectViewerDlgBar;

class CSimRobotDocument
{
private:
  BOOL m_bRunning,
       m_bStep;
  CONTROLLER* m_pController;
  SIMULATION* m_pSim;
  CString m_sStatusMessage;
  STRING m_sSection;
  // Funktioniert leider nicht mit VC 7, deswegen ganz fieser Hack
  //  CMap<CString,const CString&,int,int&> m_map; 
  CMapStringToPtr m_map;
  virtual void UpdateFrameCounts();
  int GetNumberFromWindow(CWnd* pWnd);
  CView* GetViewFromNumber(int n);
  void GenerateSceneFile(const CString& from,const CString& to);
  CString m_filePath;
public:
  void OnIdle();
  void OnSimReset();
  void OnSimStart();
  void OnSimStep();
  void Compile();
  void OnMouseClick(const CLICKINFO&);
  void OnMouseDoubleClick(const CLICKINFO&);
  void OnBeginDrag(const CLICKINFO&);
  void OnDrag(const CLICKINFO&);
  void OnEndDrag(const CLICKINFO&);
  BOOL IsRunning();
  void SetFilePath(CString path) {m_filePath=path;}
  SIMULATION* GetSimulation() {return m_pSim;}
  STRING GetSelectedObject();
  void NewSection(const STRING& sSection);
  void WriteString(const STRING& sName,const STRING& sValue);
  void WriteInt(const STRING& sName,int nValue);
  STRING ReadString(const STRING& sName);
  int ReadInt(const STRING& sName);
  CSimRobotDocument();
  virtual ~CSimRobotDocument();
  CONTROLLER* GetController() {return m_pController;}
  CSimulatorObjectViewerDlgBar* pSimulatorObjectViewerDlgBar;

  /**
   * Activates or diactivates a certain switch on the robot.
   * @param sensor The switch. Allowed values are: headBack, headFront,
   *               mouth, chin, and back.
   * @param activate Decides whether to activate or deactivate the switch.
   */
  void activateSwitch(SensorData::sensors sensor,bool activate = true)
    {m_pController->activateSwitch(sensor,activate);}

  /**
   * The function checks whether a certain switch is activated.
   * @param sensor The switch to check.
   * @return Activated or not?
   */
  bool isSwitchActivated(SensorData::sensors sensor) const
    {return m_pController->isSwitchActivated(sensor);}
};


#endif //__SimRobotDocument_h_

/* 
* Change Log:
*
* $Log: SimRobotDocument.h,v $
* Revision 1.3  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.2  2003/11/30 01:53:21  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.1  2003/10/07 10:11:08  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/03/23 14:36:08  roefer
* GenerateSceneFile added
*
* Revision 1.2  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.1  2002/09/10 15:49:12  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.2  2002/08/07 10:50:21  loetzsch
* - removed direct access to the dialogs
* - faster starting of RobotControl application and main window
* - general clean up
*
*/
