/**
* @file NonPortable.h
*
* Zweck: Anpassung an MS Windows unter Verwendung der
*        Microsoft Foundation Classes
* Datum: 20.3.94
*/

#ifndef _NONPORTABLE_H_
#define _NONPORTABLE_H_

#define COORD COORD2
#include "../../SimRob95/SimRobot/HiddenGraph.h"
#include "../../SimRob95/SimRobot/SensorClasses.h"

class CDC;
class CPen;

class MFCGRAPH : public HIDDENGRAPH
{
  CDC*  m_pDC;
  CPen* m_pPen,
      * m_pOld;
  COLOR m_lastColor;
  long  m_rgb;
  COLORLIST* m_pColorList;

  void SetColor ();
public:
  MFCGRAPH (CDC* pdc);
  ~MFCGRAPH ();
  virtual void RegisterColors (COLORLIST&);
  virtual void SetLine (const COORD&,const COORD&, COLOR);
};

class BITMAPTEXTURE : public TEXTUREDESCR
{
private:
  STRING  m_sFileName;
  int     m_xSize,
          m_ySize,
          m_hDIB;
  void    ReadDIB();
  BOOLEAN CalcSize();
public:
  BITMAPTEXTURE (STRING,STRING);
  virtual           ~BITMAPTEXTURE();
  virtual void      WriteProperties (BACKUP& backup);
  virtual void      GetSize (INTEGER& planes, REAL& width, REAL& height);
  virtual SHORTREAL GetValueAt (INTEGER plane, REAL x, REAL y);
};

#endif

/*
 * Change log:
 *
 * $Log: NonPortable.h,v $
 * Revision 1.2  2003/10/25 11:52:20  roefer
 * Simulator is SimRobXP now
 *
 * Revision 1.1  2003/10/07 10:11:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/03/28 11:37:31  timrie
 * Added changelog
 *
 */
