/**
* @file RobotControlDialogBar.cpp
*
* Implementation of class CRobotControlDialogBar
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Jngel</a>
*/

#include "RobotControl.h"
#include "RobotControlDialogBar.h"


void CRobotControlDialogBar::registerDrawingPaper(DrawingPapers::FieldDrawingPaper fieldDrawingPaper, CWnd* pWnd)
{
  getRobotControlApp().pMainFrame->debugDrawingManager.setCallBackMethod(fieldDrawingPaper, pWnd);
}

void CRobotControlDialogBar::registerDrawingPaper(DrawingPapers::ImageDrawingPaper imageDrawingPaper, CWnd* pWnd)
{
  getRobotControlApp().pMainFrame->debugDrawingManager.setCallBackMethod(imageDrawingPaper, pWnd);
}

void CRobotControlDialogBar::paintDrawingPaper(CDC* pDC, CRect* rect, DrawingPapers::FieldDrawingPaper fieldDrawingPaper)
{
  getRobotControlApp().pMainFrame->debugDrawingManager.paint(pDC, rect, fieldDrawingPaper);
}

void CRobotControlDialogBar::paintDrawingPaper(CRect* rect, DrawingPapers::ImageDrawingPaper imageDrawingPaper)
{
  getRobotControlApp().pMainFrame->debugDrawingManager.paint(rect, imageDrawingPaper);
}

CameraInfo CRobotControlDialogBar::getDebugImageCameraInfo()
{
  return getRobotControlApp().pMainFrame->debugDrawingManager.imageDrawingManager.imageYUV[Images::rawImage].cameraInfo;
}


/*
* Change Log:
*
* $Log: RobotControlDialogBar.cpp,v $
* Revision 1.3  2003/12/15 11:35:04  juengel
* Added method getDebugImageCameraInfo.
*
* Revision 1.2  2003/11/30 01:53:19  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.2  2002/09/21 10:50:13  loetzsch
* changed Doxygen comments
*
* Revision 1.1  2002/09/20 23:28:33  juengel
* Moved instance of DebugDrawingManager to RobotControlMainFrame.
*
*
*/
