/**
* @file RobotControlConfigurationManager.cpp
*
* Implementation of class CRobotControlConfigurationManager
*
* @author Martin Ltzsch
*/

#include "RobotControlConfigurationManager.h"
#include "RobotControl.h"

CRobotControlConfigurationManager& getConfigurationManager()
{
  return getRobotControlApp().configurationManager;
}

void CRobotControlConfigurationManager::init()
{
  CString configurationsString = AfxGetApp()->GetProfileString("Configurations", "Configurations");
  
  CString nextString;
  int currentReturnPosition = 0;
  configurations.RemoveAll();
  int currentLength = configurationsString.GetLength();
  while(currentLength != 0)
  {
    currentReturnPosition = configurationsString.Find(",");
    configurations.Add(configurationsString.Left(currentReturnPosition));
    configurationsString = configurationsString.Right(currentLength - currentReturnPosition - 1);
    currentLength = configurationsString.GetLength();
  }
  
  currentConfigurationName = AfxGetApp()->GetProfileString("Configurations", "SelectedConfiguration");
  
  if(configurations.GetSize() == 0)
  {
    configurations.Add("Default");
    currentConfigurationName = "Default"; 
  }
}

CRobotControlConfigurationManager::~CRobotControlConfigurationManager()
{
  CString configurationsString = "";
  for(int i=0; i < configurations.GetSize(); i++)
  {
    configurationsString.Insert(50000, configurations[i]);
    configurationsString.Insert(50000,",");
  }
  AfxGetApp()->WriteProfileString("Configurations", "Configurations", configurationsString);
  AfxGetApp()->WriteProfileString("Configurations", "SelectedConfiguration", currentConfigurationName);
}

void CRobotControlConfigurationManager::loadConfiguration()
{
  CRobotControlMainFrame* pMainFrame 
    = getRobotControlApp().pMainFrame;

  CString rebarStateString = "Configurations\\" + currentConfigurationName + "\\RebarState";
  CString dlgBarStateString = "Configurations\\" + currentConfigurationName + "\\DlgBarState";
  CString frameWndStateString = "Configurations\\" + currentConfigurationName + "\\FrameWndState";
  
  pMainFrame->OnConfigurationLoad("Configurations\\" + currentConfigurationName);

  pMainFrame->ShowWindow( SW_SHOW, _T(frameWndStateString) );
  
  pMainFrame->m_wndReBar.LoadState(_T(rebarStateString));
  CSizingControlBar::GlobalLoadState(pMainFrame,_T(dlgBarStateString));
  pMainFrame->LoadBarState(_T(dlgBarStateString));
}

void CRobotControlConfigurationManager::saveConfiguration()
{
  CRobotControlMainFrame* pMainFrame 
    = getRobotControlApp().pMainFrame;


  CString rebarStateString = "Configurations\\" + currentConfigurationName + "\\RebarState";
  CString dlgBarStateString = "Configurations\\" + currentConfigurationName + "\\DlgBarState";
  CString frameWndStateString = "Configurations\\" + currentConfigurationName + "\\FrameWndState";

  pMainFrame->OnConfigurationSave("Configurations\\" + currentConfigurationName);

  pMainFrame->m_wndReBar.SaveState( _T(rebarStateString) );
  pMainFrame->SaveBarState(_T(dlgBarStateString));
  CSizingControlBarCF::GlobalSaveState(pMainFrame,_T(dlgBarStateString));
  
  WINDOWPLACEMENT wndpl;
  wndpl.length = sizeof( wndpl );
  
  if ( pMainFrame->GetWindowPlacement( &wndpl ) )
  {
    AfxGetApp()->WriteProfileBinary( frameWndStateString,
      pMainFrame->m_lpszFrameWndPlacementEntry, ( LPBYTE )&wndpl, wndpl.length );
  }

  CString configurationsString = "";
  for(int i=0; i < configurations.GetSize(); i++)
  {
    configurationsString.Insert(50000, configurations[i]);
    configurationsString.Insert(50000,",");
  }
  AfxGetApp()->WriteProfileString("Configurations", "Configurations", configurationsString);
  AfxGetApp()->WriteProfileString("Configurations", "SelectedConfiguration", currentConfigurationName);
}

void CRobotControlConfigurationManager::deleteConfiguration()
{
  CRobotControlMainFrame* pMainFrame 
    = getRobotControlApp().pMainFrame;

  CString configurationsString = AfxGetApp()->GetProfileString("Configurations", "Configurations");
  LPTSTR lpsz = new TCHAR[currentConfigurationName.GetLength()+1];
  _tcscpy(lpsz, currentConfigurationName);
  int start = configurationsString.Find(lpsz);
 

  if (currentConfigurationName == "Default")
  {
    AfxMessageBox("The default layout cannot be deleted!", MB_OK);
    return;
  }

  configurationsString.Delete(start, currentConfigurationName.GetLength()+1);
  AfxGetApp()->WriteProfileString("Configurations", "Configurations", configurationsString);
  init();
  currentConfigurationName = "Default";
  loadConfiguration();

  /* todo: 

  actually delete the entire registry key for the configuration from 
  and not only the entry in the list!

  */ 
}

/*
* Change Log:
*
* $Log: RobotControlConfigurationManager.cpp,v $
* Revision 1.4  2004/02/26 11:10:22  jhoffman
* - enforce recompile
*
* Revision 1.3  2004/02/26 10:28:18  jhoffman
* configuration toolbar removed
*
* Revision 1.2  2004/02/23 21:35:23  jhoffman
* - message handling bug removed
* - added camera toolbar functionality to menu
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.3  2003/03/20 23:42:17  loetzsch
* changed cast of AfxGetApp() to CRobotControlApp*
* to getRobotControlApp()
*
* Revision 1.2  2003/01/19 13:04:11  loetzsch
* the settings of the simulator field view are now also stored in the registry for
* each configuration
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.2  2002/09/08 18:02:13  loetzsch
* removed some serious bugs in the configuration toolbar
*
* Revision 1.1  2002/08/13 12:58:08  loetzsch
* - Added CRobotControlConfigurationManager
*
*/
