/**
* @file RobotControl.h
*
* Declaration of class CRobotControlApp
*
* @author Martin Ltzsch
*/
#ifndef __RobotControl_h_
#define __RobotControl_h_

#include "StdAfx.h"
#include "MfcTools/IEStyleToolBars/WinAppEx.h"

#include "RobotControlMainFrame.h"
#include "RobotControlConfigurationManager.h"
#include "RobotControlDebugKeyTables.h"
#include "RobotControlQueues.h"
#include "RobotControlSimulatedRobots.h"
#include "RobotControlPhysicalRobots.h"

/**
* @class CRobotControlApp
*
* The application framework for RobotControl.
*
* Instantiates the application and loads the main frame.
*
* @author Martin Ltzsch
*/
class CRobotControlApp : public CWinAppEx
{
public:
  DECLARE_SYNC; /**< Make this object synchronizable. */
  
  /** Constructor */
  CRobotControlApp();
  
  /** Destructor */
  ~CRobotControlApp();
  
  /** The messages queues of RobotControl */
  CRobotControlQueues queues;
  
  /** The debug key tables of RobotControl */
  CRobotControlDebugKeyTables debugKeyTables;
  
  /** The configuration mangager */
  CRobotControlConfigurationManager configurationManager;
  
  /** The simulated robots */
  CRobotControlSimulatedRobots simulatedRobots;
  
  /** The WLan interface to the physical robots */
  CRobotControlPhysicalRobots physicalRobots;
  
  /** A pointer to the main frame window */
  CRobotControlMainFrame* pMainFrame;
  
  /** A pointer to the child window containing the field view */
  CMDIChildWnd* pChildWnd;
  
  //{{AFX_VIRTUAL(CRobotControlApp)
public:
  virtual BOOL InitInstance();
  virtual BOOL OnIdle( LONG lCount );
  //}}AFX_VIRTUAL
  
  // Implementation
  //{{AFX_MSG(CRobotControlApp)
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP();
};


/** returns a pointer to the RobotControl application */
CRobotControlApp& getRobotControlApp();

//{{AFX_INSERT_LOCATION}}

#endif // __RobotControl_h_

/*
* Change log :
* 
* $Log: RobotControl.h,v $
* Revision 1.2  2003/12/06 06:31:19  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:36  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.16  2003/05/12 00:22:45  dueffert
* Depend now works for RobotControl too
*
* Revision 1.15  2003/03/25 12:48:43  loetzsch
* moved the variable wlanHeartbeatInterval from RobotControl.h
* to RobotControlPhysicalRobots.cpp
*
* Revision 1.14  2003/03/25 11:46:53  dueffert
* team wlan support improved
*
* Revision 1.13  2003/03/24 14:06:17  loetzsch
* added class CRobotControlPhysicalRobot
* moved the logPlayer instance from CRobotControlApp to CRobotControlQueues
*
* Revision 1.12  2003/03/23 19:14:20  loetzsch
* finished GUI for 8 simulated robots
* - added the passive state
* - added the state[8] variable to CRobotControlSimulatedRobots
* - Repaint of object viewer after reset
* - Resend debug key table after reset
* - don't stop simulation when selected robot changes
*
* Revision 1.11  2003/03/22 22:37:52  loetzsch
* finished GUI and message routing for 8 simulated robots
* almost all functionallity for simulated robots now is encapsulated in class
*   CRobotControlSimulatedRobots
*
* Revision 1.10  2003/03/22 16:39:34  loetzsch
* continued GUI for simulated robots
*
* Revision 1.9  2003/03/20 20:36:21  loetzsch
* renamed SimulatorToolbar to Simulated Robots toolbar
* added class CRobotControlSimulatedRobots
* started implementing the GUI for 8 simulated robots
*
* Revision 1.8  2003/03/19 09:12:40  dueffert
* circle support added
*
* Revision 1.7  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.6  2003/03/05 11:08:35  loetzsch
* added class GlobalGameControlData
* the Game Toolbar now sents GlobalGameControlData
* removed Playerstoolbar
*
* Revision 1.5  2003/01/30 13:16:49  loetzsch
* Redesign of class BallPosition
*
* Revision 1.4  2003/01/28 17:18:40  loetzsch
* encapsulated the WLan thread into an own class
*
* Revision 1.3  2003/01/21 15:13:12  loetzsch
* added queueToWLan
*
* Revision 1.2  2002/11/12 16:08:10  loetzsch
* Added (char) and (int) casts to DebugDrawing Macros
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.12  2002/09/01 17:20:34  loetzsch
* tidied up the MfcTools/ directory. Created directories
* MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
*
* Revision 1.11  2002/08/30 17:12:50  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.10  2002/08/22 15:20:10  loetzsch
* debug messages to the local processes are now sent in a better synchronized way.
*
* Revision 1.9  2002/08/13 12:57:41  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
* - Renamed CLayoutToolBar to CConfigurationToolBar
* - Added CRobotControlConfigurationManager
* - Removed CToolsToolBar
*
* Revision 1.8  2002/08/08 16:40:30  loetzsch
* added class LogPlayer and redesigned RobotControl's Logplayer GUI
*
* Revision 1.7  2002/08/07 10:48:50  loetzsch
* - faster starting of RobotControl application and main window
* - general clean up
*
* Revision 1.6  2002/07/23 13:44:48  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - new debug message handling
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.5  2002/06/10 20:29:59  roefer
* Communication in a separate thread, new router is default
*
* Revision 1.4  2002/06/08 11:43:59  mkunz
* Special Percept on Field
*
* Revision 1.3  2002/06/04 23:27:02  loetzsch
* 4-robots-in-RobotControl related bug fixes and improvements
*
* Revision 1.2  2002/06/04 00:15:36  loetzsch
* RobotControl now can simulate four robots.
*
* Revision 1.1.1.1  2002/05/10 12:40:19  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.45  2002/05/04 17:43:54  loetzsch
* removed some dead code
*
* Revision 1.44  2002/05/04 12:22:55  juengel
* Moved global instance of the ColorTable64 for segmented image views from CRobotControlApp to DebugDrawingManager.cpp
*
* Revision 1.43  2002/04/23 17:45:18  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.42  2002/04/10 11:08:53  piepenstock
* added platform dependable SerialComm-Files
*
* Revision 1.41  2002/04/08 12:14:19  roefer
* Visualization of UB1 PerceptCollection from Robot improved
*
* Revision 1.40  2002/04/06 17:27:57  loetzsch
* removed unused members of debug message handler
*
* Revision 1.39  2002/04/06 09:55:52  roefer
* Image and SensorData path through DebugQueues changed
*
* Revision 1.38  2002/03/27 12:56:47  piepenstock
* Added serial communication support
*
* Revision 1.37  2002/03/24 18:15:00  loetzsch
* continued change to blocking sensor data receivers
*
* Revision 1.36  2002/03/24 14:19:46  roefer
* Input now waits for SensorData
*
* Revision 1.35  2002/02/05 20:02:15  risler
* handleDebugMessage now returns bool, added debug message handling to ImageProcessor
*
* Revision 1.34  2002/02/05 04:20:05  loetzsch
* changed CRobotControlDebugMessageHandler::handleDebugMessage()
*
* Revision 1.33  2002/01/31 12:00:26  brunn
* doku und hearbeat angepasst
*
* Revision 1.32  2002/01/30 17:31:07  loetzsch
* handleDebugMessage um Parameter timestamp erweitert
*
* Revision 1.31  2002/01/28 17:28:03  brunn
* wlanHeartbeat verbessert
*
* Revision 1.30  2002/01/28 15:07:52  loetzsch
* removed local references in CRobotControlDebugMessageHandler
*
* Revision 1.29  2002/01/28 14:00:33  loetzsch
* JointViewer continued
*
* Revision 1.28  2002/01/26 18:09:20  juengel
* DebugDrawingManager umstrukturiert.
*
* Revision 1.27  2002/01/26 03:11:27  loetzsch
* JointViewer continued
*
* Revision 1.26  2002/01/25 16:54:56  loetzsch
* Messages from OVirtualRobotComm are sent now in a synchronized way
*
* Revision 1.25  2002/01/25 15:01:42  risler
* removed ifdef WLAN
*
* Revision 1.24  2002/01/25 14:20:35  brunn
* Rckgabewerte WLan gendert
*
* Revision 1.23  2002/01/24 18:19:18  loetzsch
* JointViewer added
*
* Revision 1.22  2002/01/24 17:40:59  risler
* dummy wlan functions
*
* Revision 1.21  2002/01/24 17:23:14  brunn
* WLan - simples Protokoll eingefhrt um fragmentierte Pakete zusammenzuklauben
*
* Revision 1.20  2002/01/24 11:44:35  risler
* added WLAN Toolbar
*
* Revision 1.19  2002/01/23 13:53:03  risler
* wlan send only with connection
*
* Revision 1.18  2002/01/23 11:16:53  brunn
* WLAN im CVS nicht definieren solange kein Konfigurationsdialog existiert
*
* Revision 1.17  2002/01/23 07:51:15  loetzsch
* Behandlung von Nachrichten des Types idImageAndSensorDataAndOdometry eingebaut
*
* Revision 1.16  2002/01/21 14:30:42  brunn
* WLan Interface eingebaut - todo: Dialog fr Parameter und Connect/Disconnect
*
* Revision 1.15  2002/01/20 23:34:28  loetzsch
* Sending images and sensor data to processes running in RobotControl now possible
*
* Revision 1.14  2002/01/17 13:35:13  loetzsch
* queueToProcesses introduced an connected to OVirtualRobotComm
*
* Revision 1.13  2002/01/16 01:45:21  loetzsch
* SimRobot / RobotControl integration continued
*
* Revision 1.12  2002/01/15 23:54:15  loetzsch
* SolutionRequest introduced
*
* Revision 1.11  2002/01/14 22:43:01  loetzsch
* SimRobot / RobotControl integration started
*
* Revision 1.10  2002/01/08 15:51:47  juengel
* ModuleTester angelegt.
*
* Revision 1.9  2002/01/06 12:13:23  juengel
* Behandlung von DebugDrawings in den MessageHandler aufgenommen
*
* Revision 1.8  2001/12/20 19:22:42  juengel
* Message-Behandlung fr idColorTable eingebaut.
* SetSize der queueToRobot und queueToRobotControl vor
* das Erstellen des MainFrames gezogen.
*
* Revision 1.7  2001/12/18 16:41:50  loetzsch
* Memory Leaks beim Lesen von Text aus QueueToRobotContol ausgebaut
*
* Revision 1.6  2001/12/12 18:08:56  loetzsch
* Streaming- Operatoren fr Bilder eingebaut, DebugKeyTable nicht- statisch gemacht, Debuggin Mechanismen weitergemacht, Bilder aus Logfiles in RobotControl anzeigen, Logfiles in HU1/Debug auf den Stick schreiben
*
* Revision 1.5  2001/12/10 17:47:09  risler
* change log added
*
*/
