/**
* @file SizableReBar.h
*
* Interface for the CSizableReBar class.
*
* Copyright (c) 2001 by Nikolay Denisov. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Please email bug reports, bug fixes, enhancements, requests and
* comments to: nick@actor.ru
*/

#ifndef __SIZABLEREBAR_H__
#define __SIZABLEREBAR_H__

#include <afxtempl.h>

/** A rebar that can be resized with the mouse */
class CSizableReBar : public CControlBar
{
    DECLARE_DYNAMIC( CSizableReBar );

// Construction
public:
    CSizableReBar();
    ~CSizableReBar();

// Operations
public:
    bool Create( CWnd* pParentWnd, UINT nID, DWORD dwStyle );
    bool AddBar( CWnd* pBar, LPCTSTR pszText = 0, CBitmap* pbmp = 0,
        DWORD dwStyle = RBBS_GRIPPERALWAYS | RBBS_FIXEDBMP,
        LPCTSTR lpszTitle = 0, bool bAlwaysVisible = true );
    bool AddBar( CWnd* pBar, COLORREF clrFore, COLORREF clrBack, LPCTSTR pszText = 0,
        DWORD dwStyle = RBBS_GRIPPERALWAYS,
        LPCTSTR lpszTitle = 0, bool bAlwaysVisible = true );
    bool SetBkImage( CBitmap* pbmp );

    void EnableContextMenu( bool bCommonPart = true, bool bCustomPart = true );

    void LoadState( LPCTSTR lpszProfileName );
    void SaveState( LPCTSTR lpszProfileName );

    CReBarCtrl& GetReBarCtrl() const;

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CSizableReBar)
    public:
    virtual CSize CalcFixedLayout(BOOL bStretch, BOOL bHorz);
    virtual CSize CalcDynamicLayout(int nLength, DWORD dwMode);
    protected:
    virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
    //}}AFX_VIRTUAL

    virtual void OnUpdateCmdUI( CFrameWnd* pTarget, BOOL bDisableIfNoHandler );

// Implementation
protected:
    bool PostAddBar( CWnd* pBar, LPCTSTR lpszTitle, bool bAlwaysVisible );
    UINT GetSizingEdgeHitCode() const;
    bool GetSizingEdgeRect( const CRect& rcBar, CRect& rcEdge, UINT nHitTest ) const;
    void StartTracking( UINT nHitTest, CPoint pt );
    void StopTracking();
    void OnTrackUpdateSize( CPoint pt );

// Implementation data
protected:
    CReBar          m_wndReBar;
    UINT            m_htEdge;
    CSize           m_szCurrent;
    CSize           m_szOld;
    CPoint          m_ptOld;
    bool            m_bTracking;
    int             m_cxEdge;
    int             m_cyEdge;
    HBITMAP         m_hbmBack;
    bool            m_bCommonPart;
    bool            m_bCustomPart;

    struct BARINFO
    {
        UINT    nID;
        TCHAR   szTitle[ MAX_PATH ];
        bool    bAlwaysVisible;
    };

    CArray< BARINFO, BARINFO& > m_aBars;

    static LPCTSTR m_lpszStateInfoFormat;
    static LPCTSTR m_lpszStateInfoEntry;

// Generated message map functions
protected:
    //{{AFX_MSG(CSizableReBar)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnNcPaint();
    afx_msg void OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp);
    afx_msg UINT OnNcHitTest(CPoint point);
    afx_msg void OnCaptureChanged(CWnd *pWnd);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnNcLButtonDown(UINT nHitTest, CPoint point);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP();
};

#endif  // !__SIZABLEREBAR_H__

/*
 * Change log :
 * 
 * $Log: SizableReBar.h,v $
 * Revision 1.1  2003/10/07 10:10:08  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:49:10  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:20  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2001/12/10 17:47:10  risler
 * change log added
 *
 */
