/**
* @file FrameWndEx.cpp
*
* Implementation of extended frame classes for MDI frames and children.
*
* Copyright (c) 2001 by Nikolay Denisov. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Please email bug reports, bug fixes, enhancements, requests and
* comments to: nick@actor.ru
*/

#include "StdAfx.h"

#include "FrameWndEx.h"

/////////////////////////////////////////////////////////////////////////////
// CFrameWndEx

IMPLEMENT_DYNCREATE( CFrameWndEx, CFrameWnd )

CFrameWndEx::CFrameWndEx()
{
}

CFrameWndEx::~CFrameWndEx()
{
}

/////////////////////////////////////////////////////////////////////////////
// Overrides

void CFrameWndEx::DelayUpdateFrameMenu( HMENU hMenuAlt )
{
    // This function seems to be called by the framework only two times
    // when in-place activation begins and ends.

    if ( m_bInPlace )
    {
        VERIFY( SetMenu( 0 ) );
    }

    m_bInPlace = !m_bInPlace;

    CFrameWnd::DelayUpdateFrameMenu( hMenuAlt );
}

void CFrameWndEx::OnUpdateFrameMenu( HMENU hMenuAlt )
{
    if ( hMenuAlt == 0 )
    {
        // Attempt to get default menu from document
        CDocument* pDoc = GetActiveDocument();
        if ( pDoc != 0 )
        {
            hMenuAlt = pDoc->GetDefaultMenu();
        }
        // Use default menu stored in frame if none from document
        if ( hMenuAlt == 0 )
        {
            hMenuAlt = m_hMenuDefault;
        }
    }

    // Finally, set the menu
    if ( m_bInPlace )
    {
        VERIFY( ::SetMenu( m_hWnd, hMenuAlt ) );
    }
    else
    {
        VERIFY( m_wndMenuBar.SetMenu( hMenuAlt ) );
    }
}

/////////////////////////////////////////////////////////////////////////////
// CFrameWndEx message handlers

BEGIN_MESSAGE_MAP(CFrameWndEx, CFrameWnd)
//{{AFX_MSG_MAP(CFrameWndEx)
ON_WM_CREATE()
ON_WM_SYSCOMMAND()
ON_WM_MENUCHAR()
ON_WM_NCACTIVATE()
ON_WM_SETTINGCHANGE()
ON_WM_CLOSE()
ON_WM_INITMENUPOPUP()
ON_WM_MENUSELECT()
ON_WM_DRAWITEM()
ON_WM_MEASUREITEM()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMDIClientWndEx

IMPLEMENT_DYNCREATE( CMDIClientWndEx, CWnd )

CMDIClientWndEx::CMDIClientWndEx() : m_hWindowMenu( 0 )
{
}

CMDIClientWndEx::~CMDIClientWndEx()
{
}

/////////////////////////////////////////////////////////////////////////////
// Implementation

CMDIFrameWndEx* CMDIClientWndEx::GetParentFrame() const
{
    return STATIC_DOWNCAST( CMDIFrameWndEx, CWnd::GetParentFrame() );
}

/////////////////////////////////////////////////////////////////////////////
// CMDIClientWndEx message handlers

BEGIN_MESSAGE_MAP(CMDIClientWndEx, CWnd)
//{{AFX_MSG_MAP(CMDIClientWndEx)
//}}AFX_MSG_MAP
ON_MESSAGE( WM_MDISETMENU, OnMDISetMenu )
ON_MESSAGE( WM_MDIREFRESHMENU, OnMDIRefreshMenu )
END_MESSAGE_MAP()

LRESULT CMDIClientWndEx::OnMDISetMenu( WPARAM wParam, LPARAM lParam )
{
    m_hWindowMenu = ( HMENU )lParam;

    CMDIFrameWndEx* pFrame = GetParentFrame();
    if ( !pFrame->m_bInPlace )
    {
        VERIFY( pFrame->m_wndMenuBar.SetMenu( ( HMENU )wParam ) );
        wParam = 0;
    }

    return DefWindowProc( WM_MDISETMENU, wParam, lParam );
}

LRESULT CMDIClientWndEx::OnMDIRefreshMenu( WPARAM wParam, LPARAM lParam )
{
    LRESULT lResult = DefWindowProc( WM_MDIREFRESHMENU, wParam, lParam );

    CMenu* pWindowMenu = CMenu::FromHandle( m_hWindowMenu );
    if ( pWindowMenu != 0 )
    {
        CWinAppEx* pApp = CWinAppEx::GetInstance();
        UINT nItems = pWindowMenu->GetMenuItemCount();
        for ( UINT nIndex = 0; nIndex < nItems; nIndex++ )
        {
            UINT nID = pWindowMenu->GetMenuItemID( nIndex );
            if ( nID >= AFX_IDM_FIRST_MDICHILD )
            {
                HICON hIcon = ( HICON )::GetClassLong(
                    GetDlgItem( nID )->GetSafeHwnd(), GCL_HICONSM );
                if ( hIcon != 0 )
                {
                    pApp->ReplaceMenuIcon( nID, hIcon );
                }
                else
                {
                    pApp->RemoveMenuIcon( nID );
                }
            }
        }

    }

    return lResult;
}

/////////////////////////////////////////////////////////////////////////////
// CMDIFrameWndEx

IMPLEMENT_DYNCREATE( CMDIFrameWndEx, CMDIFrameWnd )

CMDIFrameWndEx::CMDIFrameWndEx()
{
}

CMDIFrameWndEx::~CMDIFrameWndEx()
{
}

void CMDIFrameWndEx::LoadBarState(LPCTSTR lpszProfileName)
{
  CDockState state;
  state.LoadState(lpszProfileName); // load all dock bar information from the registry
  int i,j;
  
  for (j = 0; j < 2; j++)
  {
    for (i = 0; i < state.m_arrBarInfo.GetSize(); i++)
  {
    // remove that bar infos from the list that don't exist any more in the application.
    // (A workaround for assertions that occur when an tool bar or a dialog bar was removed
    // from the application)
 		CControlBarInfo* pInfo = (CControlBarInfo*)state.m_arrBarInfo[i];
      
    if (!GetControlBar(pInfo->m_nBarID))
    {
      delete pInfo;
      state.m_arrBarInfo.RemoveAt(i);
    }
  }
  }
  
  SetDockState(state);
 
}

/////////////////////////////////////////////////////////////////////////////
// Overrides

void CMDIFrameWndEx::DelayUpdateFrameMenu( HMENU hMenuAlt )
{
    // This function seems to be called by the framework only two times
    // when in-place activation begins and ends.

    if ( m_bInPlace )
    {
        CMenu* pFrameMenu = GetMenu();
        VERIFY( SetMenu( 0 ) );

        if ( pFrameMenu != 0 )
        {
            BOOL bMaximized;
            CMDIChildWnd* pActive = MDIGetActive( &bMaximized );
            if ( ( pActive!= 0 ) && bMaximized )
            {
                if ( pFrameMenu->GetSubMenu( 0 ) == pActive->GetSystemMenu( FALSE ) )
                {
                    VERIFY( pFrameMenu->RemoveMenu( 0, MF_BYPOSITION ) );
                    VERIFY( pFrameMenu->DeleteMenu( SC_MINIMIZE, MF_BYCOMMAND ) );
                    VERIFY( pFrameMenu->DeleteMenu( SC_RESTORE, MF_BYCOMMAND ) );
                    VERIFY( pFrameMenu->DeleteMenu( SC_CLOSE, MF_BYCOMMAND ) );
                    VERIFY( pActive->ModifyStyle( 0, WS_SYSMENU ) );
                }
            }
        }
    }

    m_bInPlace = !m_bInPlace;

    CMDIFrameWnd::DelayUpdateFrameMenu( hMenuAlt );
}

void CMDIFrameWndEx::OnUpdateFrameTitle( BOOL bAddToTitle )
{
    CFrameWndBase< CMDIFrameWnd >::OnUpdateFrameTitle( bAddToTitle );

    // If our MDIChildFrame was created with ( WS_VISIBLE | FWS_ADDTOTITLE )
    // styles, then we have to refresh Window menu in order to reflect
    // MDIChildFrame title changes.  CMDIChildWnd::OnUpdateFrameTitle()
    // calls CMDIFrameWnd::OnUpdateFrameTitle(), so here we go.
    VERIFY( m_wndMDIClient.PostMessage( WM_MDIREFRESHMENU ) );
}

/////////////////////////////////////////////////////////////////////////////
// CMDIFrameWndEx message handlers

BEGIN_MESSAGE_MAP(CMDIFrameWndEx, CMDIFrameWnd)
//{{AFX_MSG_MAP(CMDIFrameWndEx)
ON_WM_CREATE()
ON_WM_SYSCOMMAND()
ON_WM_MENUCHAR()
ON_WM_NCACTIVATE()
ON_WM_SETTINGCHANGE()
ON_WM_CLOSE()
ON_WM_INITMENUPOPUP()
ON_WM_MENUSELECT()
ON_WM_DRAWITEM()
ON_WM_MEASUREITEM()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

int CMDIFrameWndEx::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
    if ( CFrameWndBase< CMDIFrameWnd >::OnCreate( lpCreateStruct ) == -1 )
    {
        return -1;
    }

    VERIFY( m_wndMDIClient.SubclassWindow( m_hWndMDIClient ) );

    return 0;
}


/////////////////////////////////////////////////////////////////////////////
// CMDIChildWndEx

IMPLEMENT_DYNCREATE( CMDIChildWndEx, CMDIChildWnd )

CMDIChildWndEx::CMDIChildWndEx()
{
}

CMDIChildWndEx::~CMDIChildWndEx()
{
}

/////////////////////////////////////////////////////////////////////////////
// CMDIChildWndEx message handlers

BEGIN_MESSAGE_MAP(CMDIChildWndEx, CMDIChildWnd)
//{{AFX_MSG_MAP(CMDIChildWndEx)
ON_WM_INITMENUPOPUP()
ON_WM_DRAWITEM()
ON_WM_MEASUREITEM()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*
* Change log :
* 
* $Log: FrameWndEx.cpp,v $
* Revision 1.2  2004/04/05 17:56:50  loetzsch
* merged the local German Open CVS of the aibo team humboldt with the tamara CVS
*
* Revision 1.2  2004/03/31 16:03:58  loetzsch
* bug fix
*
* Revision 1.1.1.1  2004/03/31 11:16:58  loetzsch
* created ATH repository for german open 2004
*
* Revision 1.1  2003/10/07 10:10:08  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/30 10:51:11  dueffert
* typos fixed
*
* Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/05/11 23:29:26  dueffert
* Depend now works with RobotControl too
*
* Revision 1.1  2002/09/10 15:49:10  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.1  2002/09/01 17:19:20  loetzsch
* tidied up the MfcTools/ directory. Created directories
* MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
*
* Revision 1.2  2002/08/13 13:00:04  loetzsch
* workaround for a bug in CFrameWnd
* RobotControl doesn't crash any more if a tool bar or dialog bar was removed.
*
* Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.2  2001/12/10 17:47:10  risler
* change log added
*
*/
